! program to test high-level Intercomm interface
! Henrique - 9/3/2003
program intercomm_test

! using InterComm
  use intercomm_interface
  use array_printing

  implicit none

! array and variable declarations
  integer, dimension (3,10,10) :: INTEGERS
  double precision, dimension (10,10) :: DOUBLES
  real, dimension (10) :: REALS
  integer :: i, j, k, ic_err

! declaring InterComm endpoint object
  type(ic_obj) :: ic

! initialize arrays
  do k = 1, 3
    do i = 1, 10
      REALS(i) = 10*(i-1)
      do j = 1, 10
        DOUBLES(i,j) = 10*(i-1)+(j-1)
        INTEGERS(k,i,j) = 500*k+(10*(i-1)+(j-1))
      end do
    end do
  end do

! creating communication endpoint
  call ic_endpoint_constructor(ic,'left:right'//CHAR(0),1,1,IC_COLUMN_MAJOR,IC_COLUMN_MAJOR,ic_err);
! testing if communication array is in a sane state
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpoint_constructor'//CHAR(0),ic_err)
    stop
  end if

  print *,">>>> dealing with a 2D double precision array"
!!!!!!!!!!!!!!!!!!!!! dealing with a 2D double precision array
  call printArray(DOUBLES)
  print *,"subarray"
! communicating parts of the DOUBLES array 
  call ic_dump_array_info(DOUBLES(2:5,4:9)); 
  call printArray(DOUBLES(2:5,4:9)); 
! exporting array section to "right" side application
  call ic_export_array(ic,DOUBLES(2:5,4:9),ic_err); 
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_export_array'//CHAR(0),ic_err)
    stop
  end if

  print *,">>>> dealing with a 1D array of reals"
!!!!!!!!!!!!!!!!!!!!! dealing with a 1D array of reals
  call printArray(REALS)
  print *,"subarray"
! communicating parts of the REALS array 
  call ic_dump_array_info(REALS(2:6)); 
  call printArray(REALS(2:6)); 
! exporting array section to "right" side application
  call ic_export_array(ic,REALS(2:6),ic_err); 
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_export_array'//CHAR(0),ic_err)
    stop
  end if

!!!!!!!!!!!!!!!!!!!!! dealing with a 3D array of integers
  call printArray(INTEGERS)
  print *,"subarray"
! communicating parts of the INTEGERS array 
  call ic_dump_array_info(INTEGERS(1:2,2:5,4:9));
  call printArray(INTEGERS(1:2,2:5,4:9));
! exporting array section to "right" side application
  call ic_export_array(ic,INTEGERS(1:2,2:5,4:9),ic_err); 
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_export_array'//CHAR(0),ic_err)
    stop
  end if

! destroying communication endpoint
  call ic_endpoint_destructor(ic);
  print *,"done"

end program intercomm_test
