#!/usr/bin/env perl 

my (@hosts,$hostfile);

sub addHost {
# making sure we are not adding repeated hosts
  my ($host)=@_;
  foreach(@hosts) {
    return if ($host eq $_);
  }
  print "adding new host [$host]\n";
  push @hosts,$host;
}

sub run {
# making sure we are not adding repeated hosts
  my ($cmdline)=@_;
  print "executing: $cmdline\n";
  `$cmdline` unless ($debug);
}

#####
#  print "Requesting ",$ENV{'MP_PROCS'}," processors...\n";
# reading configuration
  die "usage: $0 <m> <n>\n" unless (scalar(@ARGV)!=3);
  $m=$ARGV[0];
  $n=$ARGV[1];
# setting up the PVM virtual machine
  $home=$ENV{'HOME'};
  $hostfiletemp="$home/hostfile.".$$.".WE";
  # removing duplicates
  (@processors)=split(" ",$ENV{'LOADL_PROCESSOR_LIST'});
#  die "too few processors were allocated. Need to reconfigure the parameters to $$ or set total_tasks in your .cmd file as ",$m+$n,"\n" if (scalar(@processors)<$m+$n);
  foreach(@processors) {
    addHost($_);
  }
  print $n+$m," tasks will run on ",scalar(@hosts)," processors...\n";
  # setting up PVM
  run("rm -f $home/.ssh/known_hosts.bak");
  run("mv $home/.ssh/known_hosts $home/.ssh/known_hosts.bak");
  run("touch $home/.ssh/known_hosts");
  open HOSTFILE,">$hostfiletemp" || die "couldn't open '$hostfiletemp'\n";
  foreach(@hosts) {
    print HOSTFILE "add $_\n";
    run("ssh-keyscan -t rsa,dsa $_ >> $home/.ssh/known_hosts");
    run("ssh $_ 'hostname; rm -f /tmp/pvm* > /dev/null; echo halt | pvm'");
  }
  close HOSTFILE;
# setting up the virtual machine
  run("cat $hostfiletemp | pvm");
  run("rm -f $home/.ssh/known_hosts");
# restoring ssh configuration
  run("mv $home/.ssh/known_hosts.bak $home/.ssh/known_hosts");
  print "---> PVM started\n";
  @pvmconf=`echo conf | pvm`;
  foreach(@pvmconf) {
    print $_;
  }
