! program to test high-level Intercomm interface
! Henrique - 9/3/2003
program intercomm_test

  use intercomm_interface
  use array_descriptor
  use array_printing

  implicit none

  integer, dimension (3,10,10) :: INTEGERS
  double precision, dimension (10,10) :: DOUBLES
  real, dimension (10) :: REALS
  integer :: i, j, k, ic_err

  type(ic_obj) :: ic
  type(arraydesc) :: INTEGERSDesc

  ! initialize small array
  do k = 1, 3
    do i = 1, 10
      REALS(i) = 100+(10*(i-1))
      do j = 1, 10
        DOUBLES(i,j) = 100+(10*(i-1)+(j-1))
        INTEGERS(k,i,j) = 100*(k-1)+(10*(i-1)+(j-1))
      end do
    end do
  end do

! creating communication endpoint
  call ic_endpoint_constructor(ic,'right:left'//CHAR(0),1,1,IC_COLUMN_MAJOR,IC_COLUMN_MAJOR,ic_err);
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpoint_constructor'//CHAR(0),ic_err)
    stop
  end if

  print *,">>>> dealing with a 2D double precision array"
!!!!!!!!!!!!!!!!!!!!! dealing with a 2D double precision array
  print *,"before receiving data:"
  call printArray(DOUBLES)
  call ic_import_array(ic,DOUBLES(2:5,4:9),ic_err);
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_import_array'//CHAR(0),ic_err)
    stop
  end if
  print *,"after receiving data:"
  call printArray(DOUBLES)

!!!!!!!!!!!!!!!!!!!!! dealing with a 1D array of reals
  print *,"before receiving data:"
  call printArray(REALS)
  call ic_import_array(ic,REALS(2:6),ic_err);
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_import_array'//CHAR(0),ic_err)
    stop
  end if
  print *,"after receiving data:"
  call printArray(REALS)

!!!!!!!!!!!!!!!!!!!!! dealing with a 3D array of integers
  print *,"before receiving data:"
  INTEGERSDesc = createArrayDesc(INTEGERS)
  call printIntegerArray(INTEGERSDesc)
!  call ic_dump_array_info(INTEGERS); 
  call ic_import_array(ic,INTEGERS(2:3,1:4,3:8),ic_err);
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_importarray'//CHAR(0),ic_err)
    stop
  end if
  print *,"after receiving data:"
  call printIntegerArray(INTEGERSDesc)
!  call printArray(INTEGERS)

  call ic_endpoint_destructor(ic);

end program intercomm_test
