#include <iostream>
#include <A++.h>

class mytest2 {
  public:
// this works but generates a copy of the Array_Data
//    mytest2(const doubleArray& d) : my(d) {
    mytest2(const doubleArray& d) : my(d,SHALLOWCOPY) {
      d.display("parameter");
      my.display("constructor"); 
      std::cout << ">>>> TEST 0 - first element: " << my(my.getBase(0),my.getBase(1)) << endl;
    };
    void test1() {
      my.display("test1"); 
      std::cout << ">>>> TEST 1 - first element: " << my(my.getBase(0),my.getBase(1)) << endl;
    };
  protected:
    doubleArray my;
};


class mytest1 {
  public:
    mytest1(const doubleArray& d) : my(d) { 
//      my(3,3)++;
//      std::cout << ">>>> mytest1: " << my.getBase(0) << endl;
      d.display("parameter");
      my.display("constructor"); 
      std::cout << ">>>> TEST 0 - first element: " << my(my.getBase(0),my.getBase(1)) << endl;
    };
    void test1() {
      my.display("test1"); 
      std::cout << ">>>> TEST 1 - first element: " << my(my.getBase(0),my.getBase(1)) << endl;
    };
  protected:
    const doubleArray& my;
};

void g(const doubleArray& d) {
  d.display("g");
  std::cout << ">>>> TEST g - first element: " << d(d.getBase(0),d.getBase(1)) << endl;
  d(3,3)++;
  std::cout << ">>>> g: " << d.getBase(0) << endl;
}

/****
int main(int argc, char* argv[]) {
  int iNumProcs = 2;
  Optimization_Manager::Initialize_Virtual_Machine("",iNumProcs,argc,argv);

  doubleArray A(10,10);
  doubleArray B(10,10);
  A=45;
  B=5;
  Index I(3,5), J(3,5);
  const doubleArray& temp=A(I,J);

  std::cout << "------- testing g(A+B) ----\n";
  g(A+B);

  std::cout << "------- testing g(evaluate(A+B)) ----\n";
  g(evaluate(A+B));

  std::cout << "------- testing g(A(I,J)) ----\n";
  g(A(I,J));

  std::cout << "------- creating A+B ----\n";
  mytest1 m1(A+B);
  std::cout << "------- creating evaluate(A+B) ----\n";
  mytest1 m2(evaluate(A+B));
  std::cout << "------- creating A(I,J) ----\n";
  mytest1 m3(A(I,J));
  std::cout << "------- creating evaluate(A(I,J)) ----\n";
  mytest1 m4(evaluate(A(I,J)));
  std::cout << "------- creating temp ----\n";
  mytest1 m5(temp);

  std::cout << "------- testing A+B ----\n";
  m1.test1();

  // does not work
  // std::cout << "------- testing evaluate(A+B) ----\n";
  // m2.test1();

  // does not work
  // std::cout << "------- testing A(I,J) ----\n";
  // m3.test1();

  // does not work
  // std::cout << "------- testing evaluate(A(I,J)) ----\n";
  // m4.test1();

  std::cout << "------- testing temp ----\n";
  m5.test1();

  Optimization_Manager::Exit_Virtual_Machine();
}
****/

int main(int argc, char* argv[]) {
  int iNumProcs = 2;
  Optimization_Manager::Initialize_Virtual_Machine("",iNumProcs,argc,argv);

  doubleArray A(10,10);
  doubleArray B(10,10);
  A=45;
  B=5;
  Index I(3,5), J(3,5);
  const doubleArray& temp=A(I,J);

  std::cout << "------- creating mytest2 A(I,J) ----\n";
// does not work: mytest2 m1(A+B);
// works:  mytest2 m1(evaluate(A+B));
  mytest2 m1(A(I,J));

  std::cout << "------- testing mytest2 A(I,J) ----\n";
  m1.test1();

  std::cout << "------- creating mytest1 temp ----\n";
  mytest1 m2(temp);

  std::cout << "------- testing mytest1 temp ----\n";
  m2.test1();

  std::cout << "------- creating mytest1 A(I,J) ----\n";
  mytest1 m3(A(I,J));

  // does not work:
  // since the class stores a reference to an object and A(I,J) is a new 
  // temporary object, as soon as it goes way the reference is left dangling
  // std::cout << "------- testing mytest1 A(I,J) ----\n";
  // m3.test1();

  Optimization_Manager::Exit_Virtual_Machine();
}
