! This code shows data being exchanged between a Fortran90 program and a C++
! program using P++
! Auth: Henrique Andrade (hcma@cs.umd.edu)
!       University of Maryland, College Park
! Date: 01/14/2004
program intercomm_test

! using InterComm high-level API
  use intercomm_interface
  use array_printing

  implicit none

! array and variable declarations
  integer, dimension (10) :: INTEGERS
! 10 rows and 9 columns
  double precision, dimension (10,9) :: DOUBLES
! 3 2-D matrices each with 11 rows and 10 columns
  real, dimension (3,11,10) :: FLOATS
  type(arraydesc) :: FLOATSDesc
  integer :: i, j, ic_err

  type(ic_obj) :: icce

! initialize small array
  do i = 1, 10
    INTEGERS(i) = 10*(i-1)
    do j = 1, 9
      DOUBLES(i,j) = 10*(i-1)+(j-1)
    end do
  end do

! creating InterComm communication endpoint
  call ic_endpoint_constructor(icce,'left:right'//CHAR(0),1,1,IC_COLUMN_MAJOR,IC_COLUMN_MAJOR,ic_err);
! testing if communication endpoint is in sane state
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpointconstructor'//CHAR(0),ic_err)
    stop
  end if

  print *,">>>> dealing with a 1D array of integers"
!!!!!!!!!!!!!!!!!!!!! dealing with a 1D array of integers
  call printArray(INTEGERS)
! exporting array to "right" side application
  call ic_export_array(icce,INTEGERS(4:9),ic_err); 
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpointdestructor'//CHAR(0),ic_err)
    stop
  end if

  print *,">>>> dealing with a 2D double precision array"
!!!!!!!!!!!!!!!!!!!!! dealing with a 2D double precision array
  call printArray(DOUBLES)
  print *,"subarray"
! communicating parts of the DOUBLES array 
  call ic_dump_array_info(DOUBLES(2:5,4:9)); 
  call printArray(DOUBLES(2:5,4:9)); 
! exporting array to "right" side application
  call ic_export_array(icce,DOUBLES(2:5,4:9),ic_err); 
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpointdestructor'//CHAR(0),ic_err)
    stop
  end if
  call ic_import_array(icce,DOUBLES(2:5,4:9),ic_err); 
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpointdestructor'//CHAR(0),ic_err)
    stop
  end if
  print *,"after import"
  call printArray(DOUBLES)

!!!!!!!!!!!!!!!!!!!!! dealing with a 3D array of floats
  print *,"before receiving data:"
!  call ic_dumparrayinfo(FLOATS(2:3,1:4,3:8));
  call ic_dump_array_info(FLOATS);
  FLOATSdesc = createArrayDesc(FLOATS)
  call printRealArray(FLOATSdesc)
! exporting array to "right" side application
  call ic_export_array(icce,FLOATS(2:3,1:4,3:8),ic_err);
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpointdestructor'//CHAR(0),ic_err)
    stop
  end if
! importing array from "right" side application
  call ic_import_array(icce,FLOATS(2:3,1:4,3:8),ic_err);
  if (ic_err <> IC_OK) then
    call ic_print_error_message('ic_endpointdestructor'//CHAR(0),ic_err)
    stop
  end if
  print *,"after receiving data:"
  call printRealArray(FLOATSdesc)

! destroying communication endpoint
  call ic_endpoint_destructor(icce);

  print *,"done"

end program intercomm_test
