#include "boolean.h"
#include "compute_schedule.h"
#include "region.h"
#include "pgme.h"
#include "schedule.h"
#include "mbp2bdecomp.h"
#include "common.h"
#include <stdio.h>
#include <pvm3.h>

#define INIT_MSG 2000
#define MSGSIZE 500
#define  Chaos_Dereference_Offset_RangeSetOfRegion_Global Chaos_Dereference_Offset_EnumSetOfRegion_Global

int main(int nb_arg,char **arg)
{
 
  int summ = 0;
  int ii;
  char *pgme_name="Pgme1";
  char *other_pgme_name="Pgme2";
  pgme_s *my_pgme;
  pgme_s *other_pgme;
  int numNode_other;
  int me=-1;
  int numNode=-1;

  DARRAY *BP_da    ;

  double *BP_array   ;

  int i,j,k;
  int size[BP_Ndim]; 
  
  region_s *r;
  setOfRegion_s *BP_Set;
  
  
  int left[BP_Ndim];
  int right[BP_Ndim];
  int stride[BP_Ndim];
  int numproc;
  int da_size[BP_Ndim];
  
  boolean compute_remapping=true;
  boolean new_iteration    =true;
  
  sched_s *sched;

  decomp_Birreg* irr_dd;
  
  int IterationCounter=0;
  
  int SetRegionOverAllSize;
  int OverAllSize;

  int gb1,gb2;

  int LZ_count;
 
 
  //int BP_DIM1 = 3, BP_DIM2 = 3,BP_DIM3 = 3; 
  //   int BP_DIM1 = 16, BP_DIM2 = 27,BP_DIM3 = 6;
  int BP_DIM1 = 128, BP_DIM2 = 128,BP_DIM3 = 64;

  if (nb_arg < 3) {
    printf("Usage main1 #replicate #friends\n");
    exit(1);
  }
  
  numNode_other= atoi(arg[2]);

  if (numNode_other <= 0 || atoi(arg[1]) <= 0) {
    printf("Wrong value for one of the params\n");
    exit(1);
  }
  
  numNode=start_master_slave(arg);
  /*
   ** Initialise 
   **    the pvm library
   **    the chaos library
   */

  parti_pvm_setup(numNode,100,pgme_name);
  //pvm_freezegroup(pgme_name,numNode);
  PARTI_setup();

  /*
   ** Initialise the pgme structure 
   ** who am i, who are the other nodes ...
   */

  /*printf("Check 0\n"); */
  my_pgme=InitPgme("Truc1",numNode);
  other_pgme=WaitPgme("Truc2",numNode_other);

  /* printf("Check 1\n"); */

  /*
  ** pvm inquiries
   */
  numproc = NumNodePgme(my_pgme);
  me=MyPosMyPgme();

  printf("\n me(main2)=%i ",me);

  /*
  ** Read the meshes file 
  */
  
  if (me == 0) {
    /* Send dimentions */
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&BP_DIM1,1,1);
    pvm_pkint(&BP_DIM2,1,1);
    pvm_pkint(&BP_DIM3,1,1);
    pvm_bcast("Truc2",INIT_MSG);
  }

  init_timers();
  
  Sync2Pgme(my_pgme,other_pgme);

  
  // Create a DAD for Block Parti
  
  BP_da=BP_create_darray3(BP_DIM1, BP_DIM2, BP_DIM3);
  
  
  // Allocate and initialize the BP_array
  
  laSizes(BP_da,da_size);
  
  BP_array=(double *) malloc(sizeof(double)*da_size[0]*da_size[1]*da_size[2]);
  
  /**** Change Regular MB to Irregular 
	and Initialize(need to interpret Data Descriptor ******/
  
  irr_dd = DARRAY2BirregTree(BP_da);

  Initialize_distributed_array3(irr_dd,BP_array,BP_DIM1,BP_DIM2,BP_DIM3);
 

  /*
   ** create the SetOfRegion for BP
   */
  BP_Set=Alloc_setOfRegion();
  LZ_count = 0;

  

 ////////////// REGIONS /////////////////////

 /******** Very Simple case: 3x3x3 & 1 region & size LZ(27)  *******/
  /*    
  left [0]=0         ; left[1]=0          ; left[2]=0             ; 
  right[0]=2 ;         right[1]= 2;         right[2] = 2;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3);
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  */
  
  /******** Simple case: 3x3x3 & 1 region & size LZ(12)  *******/
  /*  
  left [0]=0         ; left[1]=0          ; left[2]=0             ; 
  right[0]=1 ;         right[1]= 2;         right[2] = 1;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3);
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  */
  
  /********* 16x27x6 & 3 regions& size LZ(356)  ****************/
  /*
  left [0]=1         ; left[1]=3          ; left[2]=2             ; 
  right[0]=1 ;         right[1]= 20;         right[2] = 3;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3);
    
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  


    
  left [0]=2         ; left[1]=5          ; left[2]=0             ; 
  right[0]=7 ;         right[1]= 8;         right[2] = 5;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3); 
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  



  left [0]=5         ; left[1]=18          ; left[2]=3             ; 
  right[0]=15 ;         right[1]= 25;         right[2] = 4;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3); 
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  */
  
  
  /********* 128x128x64 & 16 regions& size LZ(half data)  ****************/
  
  //region 1
  
  left [0]=0         ; left[1]=22          ; left[2]=3             ; 
  right[0]=113 ;         right[1]= 35;         right[2] = 45;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
    
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  // region 2
  
  left [0]=15         ; left[1]=69          ; left[2]=3             ; 
  right[0]=106 ;         right[1]= 127;         right[2] = 27;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  
  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);

  // region 3
  
  left [0]=8         ; left[1]=60          ; left[2]=28             ; 
  right[0]=123 ;         right[1]= 109;         right[2] = 52;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  //region 4
  
  left [0]=7         ; left[1]=16          ; left[2]=59             ; 
  right[0]=110 ;         right[1]= 118;         right[2] = 60;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  // region 5
  
  left [0]=15         ; left[1]=12          ; left[2]=55             ; 
  right[0]=118 ;         right[1]= 113;         right[2] = 58;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  // region 6
  
  left [0]=59         ; left[1]=12          ; left[2]=62             ; 
  right[0]=127 ;         right[1]= 102;         right[2] = 63;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);

  //region 7

  left [0]=23         ; left[1]=32          ; left[2]=54             ; 
  right[0]=115 ;         right[1]= 92;         right[2] = 54;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
    
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
    
  // region 8
  
  left [0]=9         ; left[1]=36          ; left[2]=0             ; 
  right[0]=100 ;         right[1]= 119;         right[2] = 0;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
 
  // region 9
  
  left [0]=5         ; left[1]=4          ; left[2]=0             ; 
  right[0]=122 ;         right[1]= 7;         right[2] = 62;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  
  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  //region 10
  
  left [0]=2         ; left[1]=69          ; left[2]=1             ; 
  right[0]=83 ;         right[1]= 127;         right[2] = 2;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  
  // region 11
  
  left [0]=14         ; left[1]=10          ; left[2]=14             ; 
  right[0]=118 ;         right[1]= 11;         right[2] = 61;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);

  // region 12
  
  left [0]=13         ; left[1]=38          ; left[2]=2             ; 
  right[0]=115 ;         right[1]= 40;         right[2] = 52;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  
  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  //region 13
  
  left [0]=33         ; left[1]=52          ; left[2]=10             ; 
  right[0]=114 ;         right[1]= 55;         right[2] = 43;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
    
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
    
  // region 14
  
  left [0]=0         ; left[1]=67          ; left[2]=25             ; 
  right[0]=4 ;         right[1]= 110;         right[2] = 57;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  // region 15

  left [0]=78         ; left[1]=17          ; left[2]=6             ; 
  right[0]=127 ;         right[1]= 17;         right[2] = 34;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);

  
  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);
  
  //region 16

  left [0]=0         ; left[1]=0          ; left[2]=0             ; 
  right[0]=0 ;         right[1]= 31;         right[2] = 0;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  
    
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  

  summ += (right[0]-left[0]+1)*(right[1]-left[1]+1)*(right[2]-left[2]+1);

  /****************************************/

  printf("SUM(main1) = %d\n",summ);
  //////////////////////////////////////////////


  Init_PVM_routes(my_pgme,other_pgme);

  //pvm_freezegroup(pgme_name,numNode);


  Sync2Pgme(my_pgme,other_pgme);

  start_timer_1(1);

  OverAllSize=SizeSetOfRegion(BP_Set);
  
  /******************** New Compute Schedules ********************/

  //  fprintf(stderr,"New compute schedule main1(%d)\n",me);

  /* 1. All to All, Both Sides */

  sched =  ComputeSchedule_Two_Compacts(SendAllToAll,irr_dd,BP_Set,my_pgme,other_pgme);


  /* 2. One to One, Both sides */


  //sched =  ComputeSchedule_Two_Compacts(SendOneToOne,irr_dd,BP_Set,my_pgme,other_pgme);



  /* 3. All to All , OneSideOnMe */


  // sched =  ComputeScheduleOnMe_Two_Compacts(SendAllToAll,irr_dd,BP_Set,my_pgme,other_pgme);


  /* 4. One to One, OneSideOnMe */

  //    sched =  ComputeScheduleOnMe_Two_Compacts(SendOneToOne,irr_dd,BP_Set,my_pgme,other_pgme);

  /* 5. All to All, OneSideOnOther */


  //sched =  ComputeScheduleOnOther_Two_Compacts(SendAllToAll,irr_dd,BP_Set,my_pgme,other_pgme);


  /* 6. One to One, OneSideOnOther */

  //      sched =  ComputeScheduleOnOther_Two_Compacts(SendOneToOne,irr_dd,BP_Set,my_pgme,other_pgme);

    
  /******************* Old Compute Schedules *********************/
  // Meta-Chaos
  /*
   sched =ComputeScheduleForSender(ComputeOnReceiver,
                                   my_pgme,BP_da,BP_Set,other_pgme,
                                   BlockParti_Dereference_HPFRegion_Local,
                                   DistributeRegularly,
				   &OverAllSize,DoNotOptComm); 
  */

   
  
  //fprintf(stderr," me = %d ---- (Old)print schedules(main1)\n\n", me);
  //PrintSched(sched);
  //fprintf(stderr," me = %d ---- (Old)End of print schedules(main1)\n\n", me);
  
  //fprintf(stderr,"after com sched\n");

  stop_timer(1);
  
  Sync2Pgme(my_pgme,other_pgme); 
   
  /********** Move Data *****************/

  start_timer_1(2);
  
  dDataMoveSend(other_pgme,sched,BP_array,1001);
  
  stop_timer(2);
  
  Sync2Pgme(my_pgme,other_pgme);
  
  
  /***************************************/
   
  /* Print local array after moving */ 
  // Not changed
  /*  {
    int i;
    
    printf("me(main1) = %d , array sizes %d %d %d\n",me, da_size[0], da_size[1], da_size[2]);
    for (i=0; i<da_size[0]*da_size[1]*da_size[2]; i++)
      printf("El %d = %f\n", i, BP_array[i] );
    
  }
  */

  printf("\n I am the process %d in main1\n",me); 
  
  {
    FILE *OutFile;

    FILE *fp_max_scheds;
    FILE *fp_avg_scheds;

    FILE *fp_max_move;
    FILE *fp_avg_move;
    
    int min1,my1,max1,avg1;
    int min2,my2,max2,avg2;

      if (me==0)
      {
	OutFile=fopen("/tmp/result_mb2mb.1","a");
	if (OutFile == NULL)
	  {
	    printf("\n /tmp/result_mb2mb.1 not open \n");
	    OutFile=stdout;
	  }
	
	fp_max_scheds = fopen("/tmp/max_sched.1","a");
        if (fp_max_scheds == NULL)
          {
            printf("\n /tmp/max_sched.1 not open \n");
            fp_max_scheds=stdout;
          }

        fp_avg_scheds = fopen("/tmp/avg_sched.1","a");
        if (fp_avg_scheds == NULL)
          {
            printf("\n /tmp/avg_sched.1 not open \n");
            fp_avg_scheds=stdout;
          }
	
        fp_max_move = fopen("/tmp/max_move.1","a");
        if (fp_max_move == NULL)
          {
            printf("\n /tmp/max_move.1 not open \n");
            fp_max_move=stdout;
          }

        fp_avg_move = fopen("/tmp/avg_move.1","a");
        if (fp_avg_move == NULL)
          {
            printf("\n /tmp/avg_move.1 not open \n");
            fp_avg_move=stdout;
          }
      }
    else
      OutFile=stdout;
    
    fprintf(OutFile,"\n-------------------------------------");
    fprintf(OutFile,"\n BP_Dim %i %i ",BP_DIM1,BP_DIM2);
    fprintf(OutFile,"\n me %i ",me);
    fprintf(OutFile,"\n numproc %i ",NumNodePgme(my_pgme));
    fprintf(OutFile,"\n numproc_other %i ",NumNodePgme(other_pgme));
    fprintf(OutFile,"\n Timers ");

    min1=return_timer_min(1) ;
    my1=return_timer(1) ;
    max1=return_timer_max(1) ;
    avg1=return_timer_avg(1) ;

    min2=return_timer_min(2) ;
    my2=return_timer(2);
    max2=return_timer_max(2) ;
    avg2=return_timer_avg(2) ;

    fprintf(OutFile,"\n                        =      min     mine      max      avg",
	    min1,my1,max1,avg1 );
    fprintf(OutFile,"\n Compute Sched MB -> MB = %8i %8i %8i %8i",
	    min1,my1,max1,avg1 );
    fprintf(OutFile,"\n remap                  = %8i %8i %8i %8i",
	    min2,my2,max2,avg2 );


    fprintf(OutFile,"\n-------------------------------------");

    if(me ==0)
      {
        fprintf(fp_max_scheds,"\n%d",max1);
        fprintf(fp_max_move,"\n%d",max2);

        fprintf(fp_avg_scheds,"\n%d",avg1);
        fprintf(fp_avg_move,"\n%d",avg2);
      }

    fclose(OutFile);

    if(me == 0)
      {
        fclose(fp_max_scheds);
        fclose(fp_avg_scheds);
        fclose(fp_max_move);
        fclose(fp_avg_move);
      }
  }

  Sync2Pgme(my_pgme,other_pgme);
  
  if(me == 0) pvm_exit();
  
  printf("\n Finished normally in main1(me=%d)\n",me);
}

/* ------------------------------------------------------------------------ */

