
# Autoconf macros for InterComm
# Christian Hansen (chansen@cs.umd.edu)
#

#
# AC_CXX_LIBRARY_LDFLAGS
#
AC_DEFUN([AC_CXX_LIBRARY_LDFLAGS], [
cat > conftest.c << _ACEOF
int main(int argc, char** argv) {
  return 0;
}
_ACEOF

AC_MSG_CHECKING([for C++ libraries of $CXX])
cxxlibs=
cxxpath=`which $CXX 2> conftest.err`
if test -x "$cxxpath"; then
  output=`eval $cxxpath -v -o conftest conftest.c 2>&1`
  case $output in
    *xlcentry*)
      # convert commas to spaces for xlC
      output=`echo $output | sed 's/,/ /g'`
      ;;
  esac
  for flag in $output; do
    case $flag in
      -lang*)
        # ignore this flag
        ;;
      -[[LRl]]*)
        cxxlibs="$cxxlibs $flag"
        ;;
    esac
  done
else
  AC_MSG_FAILURE([unable to use $CXX])
fi
rm -f conftest*
AC_MSG_RESULT([$cxxlibs])
AC_SUBST([CXXLIBS], [$cxxlibs])
])

#
# AC_PROG_F90
#
AC_DEFUN([AC_PROG_F90], [
AC_ARG_VAR([F90], [Fortran 90 compiler command])
AC_ARG_VAR([F90FLAGS], [Fortran 90 compiler flags])

# find compiler and characteristics
AC_CHECK_PROGS([F90], [$1], [none])
if test x$F90 = xnone; then
  AC_MSG_ERROR([F90 compiler not found])
fi
case "$F90" in
  *pgf*)
    f90_module_path_opt="-module "
    f90_fixed_form_opt="-Mfixed"
    f90_flags=""
    AC_SUBST([GETCWD], [getcwd])
    ;;
  *xlf*)
    f90_fixed_form_opt="-qfixed"
    f90_module_path_opt="-I"
    f90_flags="-qsuffix=f=f90"
    AC_SUBST([GETCWD], [getcwd_])
    ;;
  *f90*)
    f90_module_path_opt="-M"
    f90_fixed_form_opt="-fixed"
    f90_flags=""
    AC_SUBST([GETCWD], [getcwd])
    ;;
  *)
    AC_MSG_ERROR([unknown Fortran 90 compiler])
    ;;
esac
AC_SUBST(F90FLAGS, [$f90_flags])

# checking module path option
AC_MSG_CHECKING([for $F90 module path option])

cat >>conf/modtest.f90 <<_ACEOF
module test 
  integer a
end module test
_ACEOF

cd conf
echo "$F90 $f90_flags -c modtest.f90" >&5
$F90 $f90_flags -c modtest.f90 2>&5
if test $? -ne 0; then
  rm -f modtest* test.mod
  cd ..
  AC_MSG_FAILURE([failed!])
fi
cd ..

cat >>conftest.f90 <<_ACEOF
program main
  use test
end program main
_ACEOF

echo "$F90 $f90_flags $f90_module_path_opt$PWD/conf -c conftest.f90" >&5
$F90 $f90_flags $f90_module_path_opt$PWD/conf -c conftest.f90 2>&5
if test $? -ne 0; then
  rm -f conf/modtest* conf/test.mod conftest*
  AC_MSG_FAILURE([failed!])
else
  AC_MSG_RESULT([$f90_module_path_opt])
  AC_SUBST(F90_MOD_SWITCH, [$f90_module_path_opt])
fi
rm -f conf/modtest* conf/test.mod conftest*

# checking fixed form option
AC_MSG_CHECKING([for $F90 fixed form option])

cat >>conftest.f90 <<_ACEOF
	program main
	end program main
_ACEOF

echo "$F90 $f90_flags $f90_fixed_form_opt -c conftest.f90" >&5
$F90 $f90_flags $f90_fixed_form_opt -c conftest.f90 2>&5
if test $? -ne 0; then
  AC_MSG_FAILURE([failed!])
else
  AC_MSG_RESULT([$f90_fixed_form_opt])
  AC_SUBST(F90_FIXED_FORM, [$f90_fixed_form_opt])
fi
rm -f conftest.*
])

#
# AC_PROG_MPICXX
#
AC_DEFUN([AC_PROG_MPICXX], [
AC_ARG_VAR([MPICXX], [MPI C++ compiler command])

# find compiler and characteristics
AC_CHECK_PROGS([MPICXX], [$1], [none])
if test x$MPICXX = xnone; then
  AC_MSG_ERROR([MPI C++ compiler not found])
fi

cat >>conftest.cpp <<_ACEOF
#include <mpi.h>
int main(int argc, char** argv) {
  MPI_Init(&argc, &argv);
  MPI_Finalize();
  return 0;
}
_ACEOF

AC_MSG_CHECKING([whether the MPI C++ compiler works])
echo "$MPICXX -o conftest conftest.cpp" >&5
$MPICXX -o conftest conftest.cpp 2>&5
if test $? -ne 0; then
  AC_MSG_FAILURE([failed!])
else
  AC_MSG_RESULT([yes])
fi

ic_mpirun_found=no
if test x$2 = xyes; then
  AC_MSG_CHECKING([for MPI run command])
  case "$MPICXX" in
    *mpCC*)
      mpirun="poe"
      mpirun_proc_opt="-procs"
      ;;
    *mpiCC*)
      mpirun="mpirun"
      mpirun_proc_opt="-np"
      ;;
    *hCC*)
      mpirun="mpiexec"
      mpirun_proc_opt="-n"
      ;;
    *tmCC*)
      mpirun="mprun"
      mpirun_proc_opt="-np"
      ;;
    *)
      AC_MSG_ERROR([unknown MPI C++ compiler])
      ;;
  esac
  AC_MSG_RESULT([$mpirun])
  AC_SUBST(MPIRUN, [$mpirun])
  AC_SUBST(MPIRUN_PROC_OPT, [$mpirun_proc_opt])

  AC_MSG_CHECKING([whether the MPI run command works])
  if test $mpirun = poe; then
    mpicmd="$mpirun $PWD/conftest $mpirun_proc_opt 2"
  else
    mpicmd="$mpirun $mpirun_proc_opt 2 $PWD/conftest"
  fi
  echo $mpicmd >&5
  $mpicmd 2>&5
  if test $? -ne 0; then
    AC_MSG_RESULT([no, will skip P++ tests])
  else
    AC_MSG_RESULT([yes])
    ic_mpirun_found=yes
  fi
fi
rm -f conftest.*
])

#
# AC_CHECK_PVM_WITH_C
#
AC_DEFUN([AC_CHECK_PVM_WITH_C], [
AC_MSG_CHECKING([for pvm3.h])
CPPFLAGS="$CPPFLAGS -I$PVM_ROOT/include"
AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <pvm3.h>]), 
  AC_MSG_RESULT([yes]), 
  AC_MSG_FAILURE([no]))
AC_MSG_CHECKING([for libraries pvm3 gpvm3])
LDFLAGS="$LDFLAGS -L$PVM_ROOT/lib/$PVM_ARCH"
libs="$LIBS"
LIBS="-lgpvm3 -lpvm3 $LIBS"
AC_LINK_IFELSE(AC_LANG_PROGRAM([#include <pvm3.h>], [
	int p; 
	p = pvm_parent(); 
	pvm_exit();
  ]), 
  AC_MSG_RESULT([found]), 
  AC_MSG_FAILURE([failed!]))
LIBS="$libs"
])

#
# AC_CHECK_PVM_WITH_FORTRAN
#
AC_DEFUN([AC_CHECK_PVM_WITH_FORTRAN], [
AC_LANG_PUSH([Fortran 77])
AC_MSG_CHECKING([for fpvm3.h])
FFLAGS="$FFLAGS -I$PVM_ROOT/include"
AC_COMPILE_IFELSE(AC_LANG_PROGRAM([], [
	include 'fpvm3.h'
  ]),
  AC_MSG_RESULT([yes]),
  AC_MSG_FAILURE([no]))
AC_MSG_CHECKING([for library fpvm3])
LDFLAGS="$LDFLAGS -L$PVM_ROOT/lib/$PVM_ARCH"
libs="$LIBS"
LIBS="-lfpvm3 -lgpvm3 -lpvm3 $LIBS"
AC_LINK_IFELSE(AC_LANG_PROGRAM([], [
	include 'fpvm3.h'
	integer p
	call pvmfparent(p)
	call pvmfexit(p)
  ]),
  AC_MSG_RESULT([found]),
  AC_MSG_FAILURE([failed!]))
LIBS="$libs"
AC_LANG_POP([Fortran 77])
])

#
# AC_CHECK_CHAOS
#
AC_DEFUN([AC_CHECK_CHAOS], [
AC_MSG_CHECKING([for ttable.h])
AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <ttable.h>]), 
  AC_MSG_RESULT([yes]), 
  AC_MSG_FAILURE([no]))
AC_MSG_CHECKING([for library chaos])
libs="$LIBS"
LIBS="$LIBS -lchaos -lgpvm3 -lpvm3"
AC_LINK_IFELSE(AC_LANG_PROGRAM([#include <ttable.h>], [
	TTABLE* t; 
	t = build_translation_table(1,1,1);
  ]), 
  AC_MSG_RESULT([found]), 
  AC_MSG_FAILURE([failed!]))
LIBS="$libs"
])

#
# AC_CHECK_MBP
#
AC_DEFUN([AC_CHECK_MBP], [
ic_new_mbp_found=no
ic_mbp_uses_mpi=no
AC_MSG_CHECKING([for MBP version])
for flag in $CPPFLAGS; do
  dir=`expr match $flag "-I\(.*\)"`
  if test -f "$dir/multiblockparti.h"; then
    ic_new_mbp_found=yes
    continue
  fi
done
if test $ic_new_mbp_found = yes; then
  AC_MSG_RESULT([2])

  # mbp built with pvm or mpi?
  AC_MSG_CHECKING([whether MBP uses PVM or MPI])
  res=`grep "#define USE_MPI 1" $dir/port.h`
  if test "x$res" = "x"; then
    AC_MSG_RESULT([PVM])
    cc="$CC"
    libs="$LIBS"
    LIBS="$LIBS -lMBP -lgpvm3 -lpvm3"
  else
    AC_MSG_RESULT([MPI])
    cc="$CC"
    CC=$MPICC
    libs="$LIBS"
    LIBS="$LIBS -lMBP"
    ic_mbp_uses_mpi=yes
  fi
  AC_DEFINE(MBP_VERSION, 2, [Define the version of the MBP library])
  AC_MSG_CHECKING([for multiblockparti.h])
  AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <multiblockparti.h>]),
    AC_MSG_RESULT([yes]),
    AC_MSG_FAILURE([no]))
  AC_MSG_CHECKING([for library MBP])
  AC_LINK_IFELSE(AC_LANG_PROGRAM([#include <multiblockparti.h>], [
	parti_decomp_t* d;
	int* s;
	d = parti_create_idecomp(1, s);
    ]),
    AC_MSG_RESULT([found]),
    AC_MSG_FAILURE([failed!]))
  LIBS="$libs"
  CC="$cc"
else
  AC_MSG_RESULT([1])
  AC_DEFINE(MBP_VERSION, 1, [Define the version of the MBP library])
  AC_MSG_CHECKING([for bsparti.h])
  AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <bsparti.h>]),
    AC_MSG_RESULT([yes]),
    AC_MSG_FAILURE([no]))
  AC_MSG_CHECKING([for library MBP])
  libs="$LIBS"
  LIBS="$LIBS -lMBP -lchaos -lgpvm3 -lpvm3"
  AC_LINK_IFELSE(AC_LANG_PROGRAM([#include <bsparti.h>], [
	DECOMP* d; 
	int* s; 
	d = create_decomp(1,s);
    ]),
    AC_MSG_RESULT([found]),
    AC_MSG_FAILURE([failed!]))
  LIBS="$libs"
fi
])

#
# AC_CHECK_PPP
#
AC_DEFUN([AC_CHECK_PPP], [
AC_DEFINE(MBP_VERSION, 1, [Define the version of the MBP library])
AC_LANG_PUSH([C++])
#cxxflags="$CXXFLAGS"
case "$CXX" in
  *xlC*)
    CXXFLAGS="$CXXFLAGS -qlanglvl=redefmac"
    ;;
esac
cxx="$CXX"
CXX="$MPICXX"
AC_MSG_CHECKING([for A++.h])
AC_COMPILE_IFELSE(AC_LANG_PROGRAM([#include <A++.h>]),
  AC_MSG_RESULT([yes]),
  AC_MSG_FAILURE([no]))
AC_MSG_CHECKING([for libraries Ppp Ppp_static])
libs="$LIBS"
LIBS="-lPpp -lPpp_static $LIBS"
AC_LINK_IFELSE(AC_LANG_PROGRAM([#include <A++.h>], [
	int argc;
	char** argv;
	Optimization_Manager::Initialize_Virtual_Machine(*argv, argc, argc, argv);
	Optimization_Manager::Exit_Virtual_Machine();
  ]),
  AC_MSG_RESULT([found]),
  AC_MSG_FAILURE([failed!]))
LIBS="$libs"
CXX="$cxx"
#CXXFLAGS="$cxxflags"
AC_LANG_POP([C++])
])
