#include <mpi.h>
#include <unistd.h>
#include <stdio.h>

int main(int argc, char* argv[]) {
  int sts, rank, size;
  MPI_Comm comm;

  MPI_Init(&argc, &argv);

  MPI_Comm_split(MPI_COMM_WORLD, MPI_UNDEFINED, 0, &comm);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  
  if (argc > 1) {
    int pid = fork();
    if (pid == 0) {
      printf("Executing program: <%s>\n", argv[1]);
      execvp(argv[1], argv+1);
      perror(argv[0]);
    }
  }

  MPI_Finalize();

  return 0;
}
