#include <intercomm.h>
#include <stdio.h>
#include <mpi.h>

int main(int argc, char* argv[]) {
  IC_Program* red, *orange, *green, *yellow;
  MPI_Comm comm;

  MPI_Init(&argc, &argv);
  MPI_Comm_split(MPI_COMM_WORLD, COLOR, 0, &comm);

  red = IC_Init("red", 1, 0);
  orange = IC_Wait("orange", 1);
  green = IC_Wait("green", 1);
  yellow = IC_Wait("yellow", 1);

  if (IC_Sync(red, orange) < 0)
    fprintf(stderr, "red could not sync with orange\n");
  if (IC_Sync(red, green) < 0)
    fprintf(stderr, "red could not sync with green\n");
  if (IC_Sync(red, yellow) < 0)
    fprintf(stderr, "red could not sync with yellow\n");
  
  IC_Free_program(yellow);
  IC_Free_program(green);
  IC_Free_program(orange);

  IC_Quit(red);
  
  MPI_Comm_free(&comm);
  MPI_Finalize();

  return 0;
}
