//This example illustrates the "proper" use of the A++/P++ libs.
// The idea is to avoid scalar indexing (eg. the kind of indexing
// you normally do in fortran or C)  through the use of
// the Index and Range Objects.   Scalar indexing is
// very slow, especially for P++, inwhich the arrays are distributed
// over the processors, and considerable amount of communication is necesary to
// retrieved the indexed values.


#include <A++.h>
#include <time.h>

int main(int argc,char** argv) {
  int num_of_process=4;
  Optimization_Manager::Initialize_Virtual_Machine(" ",num_of_process,argc,argv);

  // Instance the doubleArray objects //

  int grid_size=10;
  doubleArray Solution(grid_size);
  doubleArray Solution2(grid_size);
  doubleArray temp(grid_size);

  //Other variables
  double time1,time2,time_total,time2_total;
  double Jacobi=5; 	// number of steps in the Jacobi relaxation 
  int i,j;

  //Instance the Range(or Index) objects
  Range I(1,grid_size-2,1);

  //Initialize the  doubleArray objects//
  Solution=0.0;
  Solution2=0.0;
  Solution(I)=1.0;
  Solution2(I)=1.0;

  I.display("is this possible?");
  // Solving 1-d equation using Index object.  
  time1=clock();
  for (i=1;i<=Jacobi;i++){
    Solution(I-1).display(">>>>> I-1");
    Solution(I+1).display(">>>>> I+1");
    Solution(I)=(Solution(I-1)+Solution(I+1))/2; 
    Solution(I).display(">>>>> I");
    cout << "------------------------------------------------------\n";
  }
  time2=clock();
  Solution.display("index");
  time_total=time2-time1;
  printf("index done");

  /****
  // equivalent expression with scalar (array) indexing //
  time1=clock();
          for (i=1;i<=Jacobi;i++){
          for (j=1;j<=8;j++){
                  temp(j)=(Solution2(j-1)+Solution2(j+1))/2;}
          for (j=0;j<=9;j++){
                  Solution2(j)=temp(j);}}
  time2=clock();
  time2_total=time2-time1;
  Solution2.display("scalar");

  // times taken by 
  cout <<time_total<<" "<<time2_total<<"\n";
  ***/

  printf("program terminated properly");

  Optimization_Manager::Exit_Virtual_Machine();
}
