#include <intercomm.h>
#include <pvm3.h>
#include <stdio.h>

IC_Desc* create_ttable(int p, int r, float A[200]) {
  int globals[200], offsets[200], tasks[200];
  IC_Desc* desc;
  int i;
  
  /* assign this processor the rth portion of global index space */
  for (i = 0; i < 200; ++i) {
    globals[i] = 200*r + i;
  }
  
  /* round-robin global index to task assignment */
  for (i = 0; i < 200; ++i) {
    offsets[i] = i/p + 50*r;
    tasks[i] = i%p;
  }
  
  /* create the ic descriptor */
  desc = IC_Create_ttable_desc(globals, offsets, tasks, 200);
  
  /* assign each local value its global index */
  for (i = 0; i < 200; ++i) {
    A[i] = globals[i];
  }
  
  return desc;
}


int main(int argc, char* argv[]) {
  char* localname = "cexample";
  char* othername = "fexample";
  int local_tasks = 4; 
  int other_tasks = 8;
  int i, rank;
  
  char* groupcomm = "local_c";

  IC_Program* local;
  IC_Program* other;
  
  IC_Desc* desc;
  float A[200];
  
  IC_Region* region_set[2];
  int indices[8];
  IC_Sched* sched;
  int tag = 99;
  
  /* initialize pvm */
  printf("initialize pvm\n");
  rank = pvm_joingroup(groupcomm); 
  pvm_barrier(groupcomm, local_tasks);
  
  /* initialize ic */
  printf("initialize ic\n");
  local = IC_Init(localname, local_tasks, rank);
  other = IC_Wait(othername, other_tasks);
  IC_Sync(local, other);

  desc = create_ttable(local_tasks, rank, A);

  /* define two 8 element regions for transfer */
  printf("define regions\n");
  for (i = 0; i < 8; ++i)
    indices[i] = i;
  region_set[0] = IC_Create_enum_region(indices, 8);
  for (i = 0; i < 8; ++i)
    indices[i] = i + 400;
  region_set[1] = IC_Create_enum_region(indices, 8);
  
  /* create a translation table type array descriptor and array */
  printf("create schedule\n");
  sched = IC_Compute_schedule(local, other, desc, region_set, 2);
  printf("send data\n");
  IC_Send_float(other, sched, &A[0], tag);
  IC_Sync(local, other);
  IC_Free_sched(sched);
  
  /* clean up */
  printf("clean up\n");
  IC_Free_region(region_set[1]);
  IC_Free_region(region_set[0]);

  IC_Free_desc(desc);

  IC_Free_program(other);
  IC_Quit(local);

  pvm_barrier(groupcomm, local_tasks);
  pvm_lvgroup(groupcomm);
  pvm_exit();
  
  return 0;
}
