      program fexample
      implicit none
      include 'fpvm3.h'

      character*8 localname
      data localname / 'fexample' /
      character*8 othername
      data othername / 'cexample' /
      integer local_tasks
      data local_tasks / 8 /
      integer other_tasks
      data other_tasks / 4 /
      integer i, rank

      character*7 groupcomm
      data groupcomm / 'local_f' /
      
      integer local
      integer other

      integer desc
      real A(5,5,5)
      
      integer region_set(2)
      integer lower(3), upper(3), stride(3)
      integer sched
      integer tag
      data tag / 99 /

      integer sts

c     initialize pvm
      print *, 'initialize pvm'
      call pvmfjoingroup(groupcomm, rank)
      call pvmfbarrier(groupcomm, local_tasks, sts)

c     initialize ic
      print *, 'initialize ic'
      call IC_Init(localname, local_tasks, rank, local)    
      call IC_Wait(othername, other_tasks, other)
      call IC_Sync(local, other, sts)

c     create a block decomposition type array descriptor and array
      call create_bdecomp(local_tasks, rank, A, desc)

c     define two 2x2x2 regions for transfer
      print *, 'define regions'
      do i = 1, 3
         lower(i) = 1
         upper(i) = 2
         stride(i) = 1
      end do
      call IC_Create_block_region(3, lower, upper, stride, 
     $     region_set(1))    
      do i = 1, 3
         lower(i) = 6
         upper(i) = 7
         stride(i) = 1
      end do
      call IC_Create_block_region(3, lower, upper, stride, 
     $     region_set(2))    
      
      print *, 'create schedule'
      call IC_Compute_schedule(local, other, desc, region_set,
     $     2, sched)
      print *, 'receive data'
      call IC_Recv_float(other, sched, A, tag, sts)     
      call IC_Sync(local, other, sts)
      call IC_Free_sched(sched)
      
c     cleanup
      print *, 'clean up'
      call IC_Free_region(region_set(2))
      call IC_Free_region(region_set(1))

      call IC_Free_desc(desc)

      call IC_Free_program(other)      
      call IC_Quit(local, sts)
      
      call pvmfbarrier(groupcomm, local_tasks, sts)
      call pvmflvgroup(groupcomm, sts)
      call pvmfexit(sts)

      end


      subroutine create_bdecomp(p, r, A, desc)
      implicit none
      integer p, r
      real A(5,5,5)
      integer desc

      integer blocks(8,2,3)
      integer tasks(8)      
      integer i, j, k
      
c     bisect the global array in each dimension
      do i = 0, 1
         do j = 0, 1
            do k = 0, 1
               blocks(4*i+2*j+k+1,1,1) = i*5 + 1
               blocks(4*i+2*j+k+1,2,1) = i*5 + 5
               blocks(4*i+2*j+k+1,1,2) = j*5 + 1
               blocks(4*i+2*j+k+1,2,2) = j*5 + 5
               blocks(4*i+2*j+k+1,1,3) = k*5 + 1
               blocks(4*i+2*j+k+1,2,3) = k*5 + 5
            end do
         end do
      end do

c     assign the blocks to the tasks
      do i = 1, 8
         tasks(i) = i - 1
      end do
      
c     create the ic descriptor
      call IC_Create_bdecomp_desc(3, blocks, tasks, 8, desc)
      
c     assign each local element a number based on its index
      do i = 1, 5
         do j = 1, 5
            do k = 1, 5
               A(i,j,k) = 1000*r + 100*i + 10*j + k
            end do
         end do
      end do
      
      end
