/* 
 * File: communication.h
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: functions for communication.
 *       Some functions from Meta-Chaos.
 * Date: Feb. 2004
 */

#ifndef COMMUNICATION_H
#define COMMUNICATION_H

#include "schedule.h"
#include "pgme.h"
#include "region.h"
#include "global.h"
#include "general_bsparti.h"
#include "simple_ttable.h"
#include "compute_schedule.h"


typedef struct {
  int numproc;
  int mem_layout;
  setOfRegion_s *ar_Set;
  block*** block_array;
  int* num_of_blocks_others;
} info_dd_arSet;

/* Some of them are not used in IC */
#define FLAG_REQUETE      1000
#define FLAG_SCHEDULE     1001
#define FLAG_Broadcast1   1002
#define FLAG_Broadcast2   1003
#define FLAG_DAD          1004
#define FLAG_TTABLE       1005


void SendSched(pgme_s *pgme, int to, sched_s *sched, int tag);
void SendSchedTab(pgme_s *pgme, int to, sched_s** tab_sched, int tag);

sched_s *RecvSched(pgme_s *computesched_pgme, sched_s *sched, int tag);
sched_s *RecvScheds(pgme_s *computesched_pgme1, pgme_s *computesched_pgme2, sched_s *sched, int tag);
sched_s *RecvSchedReverseOrder(pgme_s *computesched_pgme, sched_s *sched, int tag);
sched_s** RecvSchedTab(pgme_s *computesched_pgme, int from, sched_s** tab_sched, int tag);

int exch_desctype(pgme_s *other_pgme, int type);
int exch_size_regions(pgme_s *other_pgme, int num_data);
void exch_transfer_info(pgme_s *other_pgme, int type,int num_data, int* other_type, int* other_num_data);



void Free_info_dd_arSet(info_dd_arSet* info);
void send_compact_DAD_SetOfRegions(HowToSendDAD howsend, 
				   int me, 
				   setOfRegion_s* ar_Set, 
				   void* datadescriptor, 
				   pgme_s* my_pgme, 
				   pgme_s* other_pgme);

info_dd_arSet* receive_compact_DAD_SetOfRegions(HowToSendDAD howsend, 
						int me, 
						pgme_s* my_pgme, 
						pgme_s* other_pgme);

/* send and receive necessary ttable info */
void send_ttable_info(pgme_s* my_pgme,
		      simple_ttable* ttable,
		      setOfRegion_s* my_ar_Set,
		      int overall_size);

simple_ttable* receive_ttable_info(pgme_s* my_pgme, 
				   int overall_size);

void send_ttable_info_two_pgmes(pgme_s* first_pgme,
				pgme_s* second_pgme,
				simple_ttable* ttable,
				setOfRegion_s* my_ar_Set,
				int overall_size,
				pgme_s* my_pgme);

simple_ttable* receive_ttable_info_two_pgmes(int incr,
					     pgme_s* my_pgme,
					     pgme_s* other_pgme, 
					     int overall_size,
					     int my_other);

/* to send and receive DAD and ArSet info */
int* build_info(int nDims,  
		setOfRegion_s* ar_Set,
		int num_blocks,
		block** block_array,
		int mem_layout,
		int* temp_count);

void send_DD_arSet(pgme_s* my_pgme,
		   pgme_s* other_pgme, 
		   int* temp_buff,
		   int temp_count);

void send_DD_arSet_One2One(pgme_s* my_pgme, 
			   pgme_s* other_pgme,
			   int* temp_buff,
			   int temp_count);

int* receive_DD_arSet(int source);

info_dd_arSet* interpret_info(int* buffer,
			      pgme_s* my_pgme,
			      pgme_s* other_pgme);

int cal_source_node(pgme_s* my_pgme, 
		    pgme_s* other_pgme);


#endif /* COMMUNICATION_H */
