#ifndef CARRAY_DESCRIPTOR_H
#define CARRAY_DESCRIPTOR_H

#include "InterComm.h"
#include "ic_config.h"

struct F90_charArray {
  char* base;
  int rank;
  int shape[IC_MAX_DIM];
  int stride[IC_MAX_DIM];
};

struct F90_shortArray {
  short* base;
  int rank;
  int shape[IC_MAX_DIM];
  int stride[IC_MAX_DIM];
};

struct F90_intArray {
  int* base;
  int rank;
  int shape[IC_MAX_DIM];
  int stride[IC_MAX_DIM];
};

struct F90_floatArray {
  float* base;
  int rank;
  int shape[IC_MAX_DIM];
  int stride[IC_MAX_DIM];
};

struct F90_doubleArray {
  double* base;
  int rank;
  int shape[IC_MAX_DIM];
  int stride[IC_MAX_DIM];
};


#define PRINTCHARARRAY_F77 F77_FUNC_(printchararray, PRINTINTARRAY)
#define PRINTSHORTARRAY_F77 F77_FUNC_(printshortarray, PRINTINTARRAY)
#define PRINTINTARRAY_F77 F77_FUNC_(printintegerarray, PRINTINTARRAY)
#define PRINTFLOATARRAY_F77 F77_FUNC_(printrealarray, PRINTFLOATARRAY)
#define PRINTDOUBLEARRAY_F77 F77_FUNC_(printdoublearray, PRINTDOUBLEARRAY)

extern "C" {

void PRINTINTARRAY_F77(const F90_intArray** A);
void PRINTFLOATARRAY_F77(const F90_floatArray** A);
void PRINTDOUBLEARRAY_F77(const F90_doubleArray** A);

}

#endif
