/*
 * File: general_bsparti.c
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: 
 * Date: 
 */

#include "general_bsparti.h"
#include <stdio.h>
#include <stdlib.h>

decomp_Birreg* Allocate_decomp_Birreg(int nDims) 
{
  decomp_Birreg* decomp;
  
  decomp = (decomp_Birreg*)malloc(sizeof(decomp_Birreg));
  decomp->nDims = nDims;
  decomp->root = (Decomp_TREE*)malloc(sizeof(Decomp_TREE));

  return decomp;
}

void Free_Decomp_Birreg(decomp_Birreg* decomp)
{
  if (decomp) {
    Free_Decomp_TREE(decomp->root);
    free(decomp->root);
    free(decomp);
  }
}

void Free_Decomp_TREE(Decomp_TREE* irr_dd)
{
  int i;

  if (irr_dd->num_of_partitions == 0) {
    Free_Block(irr_dd->block_info);
  } else {
    for (i = 0; i < irr_dd->num_of_partitions; ++i) {
      Free_Decomp_TREE(&(irr_dd->children[i]));
    }
    free(irr_dd->children);
    free(irr_dd->keys);
  }  
}

void print_irr(Decomp_TREE* irr_dd)
{
  int i,j;
  
  if (irr_dd->children) {
    for (i = 0; i < irr_dd->num_of_partitions; i++)
      print_irr(&(irr_dd->children[i]));
  }
  else {
    printf("\n******* start of block info ***********\n");
    printf(" ownership : %d\n",irr_dd->block_info->proc);
    
    for (j = 0; j < irr_dd->nDims; j++) {
      printf(" size(Dim %d) : %d\n",j, irr_dd->block_info->size[j]);
      printf(" global_start(Dim %d) : %d\n",j, irr_dd->block_info->start_global[j]);
      printf(" global_end(Dim %d) : %d\n",j, irr_dd->block_info->end_global[j]);
      printf(" coordinate(Dim %d) : %d\n",j, irr_dd->block_info->coord[j]);
    }
  }
}

block* Allocate_Block(int nDims)
{
  block* b;
  
  b = (block*)malloc(sizeof(block));
  b->nDims = nDims;  
  b->size = (int*)malloc(nDims*sizeof(int));
  b->start_global = (int*)malloc(nDims*sizeof(int));
  b->end_global = (int*)malloc(nDims*sizeof(int));
  b->coord = (int*)malloc(nDims*sizeof(int));
  
  return b;
}

void Free_Block(block* b)
{
  free(b->size);
  free(b->start_global);
  free(b->end_global);
  free(b->coord);  
  free(b);
}

int get_num_of_blocks(decomp_Birreg* irr_dd)
{
  return get_num_of_blocks_TREE(irr_dd->root);  
}

int get_num_of_blocks_TREE(Decomp_TREE* root)
{
  int i;
  int res = 0;

  if (root->block_info) { /* a leaf */
    return 1;
  }
  else {
    for (i = 0; i < root->num_of_partitions; i++)
      res += get_num_of_blocks_TREE(&root->children[i]);
    return res;    
  }
}

void store_block_array_ptr(decomp_Birreg* irr_dd, block** block_array)
{
  store_block_array_ptrs(irr_dd->root, block_array, 0); 
}

int store_block_array_ptrs(Decomp_TREE* root, block** block_array, int pos)
{
  int i;
  int res = 0;
  int total = 0;
  
  if (root->block_info) {
    /* a leaf */
    block_array[pos] = root->block_info;
    return 1;
  }
  else {
    for (i = 0; i < root->num_of_partitions ; i++) {
      res = store_block_array_ptrs(&root->children[i], block_array, pos);
      pos += res;
      total += res;
    }  
    return total;
  }
}

void Print_block(int dim, block* b)
{
  int i;
  
  printf("\n---------- Block --------\n\n");
  printf("Ownership: Proc = %d\n", b->proc);
  
  for (i = 0; i < dim; i++) {
    printf("size[%d] = %d\n",i,b->size[i]);
    printf("start[%d] = %d\n",i,b->start_global[i]);
    printf("end[%d] = %d\n",i,b->end_global[i]);
    printf("coord[%d] = %d\n",i,b->coord[i]);
  }
  
  printf("\n-------------------------\n\n");
}

void file_Print_block(FILE* fp,int dim, block* b)
{
  int i;
  
  fprintf(fp,"\n---------- Block --------\n\n");
  fprintf(fp,"Ownership: Proc = %d\n", b->proc);
  
  for (i = 0; i < dim; i++) {
    fprintf(fp,"size[%d] = %d\n",i,b->size[i]);
    fprintf(fp,"start[%d] = %d\n",i,b->start_global[i]);
    fprintf(fp,"end[%d] = %d\n",i,b->end_global[i]);
    fprintf(fp,"coord[%d] = %d\n",i,b->coord[i]);
  }
  
  fprintf(fp,"\n-------------------------\n\n");
}

block** get_my_blocks(int me, block** block_array, int num_blocks, int* num_my_blocks, int nDims)
{
  int i, j;
  int my_count;
  int number_my_blocks;
  
  block** mine;
  
  number_my_blocks = 0;
  for (i = 0; i < num_blocks; i++) {
    if (block_array[i]->proc == me)
      number_my_blocks++;
  }
  
  mine = (block**)malloc(number_my_blocks*sizeof(block*));  
  my_count = 0;
  
  for (i = 0; i < num_blocks; i++) { 
    if (block_array[i]->proc == me) { 
      mine[my_count++] = block_array[i];
    }
  }
  
  *num_my_blocks = number_my_blocks;
  
  return mine;
}
