// Henrique Andrade - March 2003
// University of Maryland, College Park
//
// Class Description:
// 
// This is an abstract class for an Interpolator. It allows exporting/importing
// of distributed Pplusplus arrays. 
//
// For now it's a very primitive API with import, export, and amplify methods.
// The latter is example of the kind of manipulations that can be done inside
// the interpolator.
//
// The communication endpoint is used to establish a (bidirectional)
// pipe between two parallel applications. A developer can implement EndPoints
// using whatever kind of communication he/she wishes. The abstract EndPoint
// class is also defined here.

#ifndef ENDPOINT_H
#define ENDPOINT_H

#include <fstream>
#include "InterComm.h"

class EndPoint {
  public:
    enum {
      // ERRORS
      EP_OK          =  0,
      EP_WRITE_ERROR = -1,
      EP_READ_ERROR  = -2,
      EP_CLOSE_ERROR = -3
    };
    EndPoint(const char* myname);
    virtual ~EndPoint();
  protected:
    char name[IC_MAX_STR];
};

#endif
