#include <A++.h>
#include <assert.h>
#include <fstream>
#include <iostream>
#include <stdio.h>
#include <string.h>
#include <strstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "FILE_EndPoint.h"

//#define VERBOSE

bool FILE_EndPoint::isLocalProgramInitzd=false;

FILE_EndPoint::FILE_EndPoint(const char* myname) :
  EndPoint(myname) {
  char temp1[IC_MAX_STR], temp2[IC_MAX_STR];
  // let's parse the interpolator name and get the info we need
  int ret=sscanf(myname,"%[A-z0-9]%*[ :]%[A-z0-9]",temp1,temp2);
  assert(ret==2);
  assert(strcmp(temp1,temp2)!=0);
  snprintf(myName,IC_MAX_STR,"ep-%s-%s-ep",temp1,temp2);
  snprintf(otherName,IC_MAX_STR,"ep-%s-%s-ep",temp2,temp1);
  if (!isLocalProgramInitzd) {
    std::cout << "local program [" << temp1 << "] has started...\n";
    isLocalProgramInitzd=true;
  }
}

int FILE_EndPoint::write(const char* buf, const unsigned nbytes) {
  unsigned i=0;
  int ret;
  char tempName[IC_MAX_STR];
  ret=snprintf(tempName,IC_MAX_STR-1,"%s-temp",myName);
  assert(ret>0);
  do {
    struct stat fs;
    ret=stat(tempName,&fs);
    if (ret==0) {
#ifdef VERBOSE
      if (i==0)
        std::cout << "waiting for '" << tempName << "' to be consumed...\n";
#endif
      ret=usleep(FILE_EndPoint::SLEEP_TIME);
      assert(ret==0);
      i++;
    }
  }
  while(ret==0);
#ifdef VERBOSE
  if (i>0)
    std::cout << "'" << tempName << "' was consumed...\n";
#endif
  f.open(tempName,std::ios::out);
  assert(f);

  // lets write the data now

  f.write(buf,nbytes);
  if (f.fail())
    return EP_WRITE_ERROR;
  f.close();
  if (f.fail())
    return EP_CLOSE_ERROR;

  // lets close the file now

  do {
    struct stat fs;
    ret=stat(myName,&fs);
    if (ret==0) {
#ifdef VERBOSE
      if (i==0)
        std::cout << "waiting for '" << myName << "' to be consumed...\n";
#endif
      ret=usleep(FILE_EndPoint::SLEEP_TIME);
      assert(ret==0);
      i++;
    }
  }
  while(ret==0);
  ret=rename(tempName,myName);
  if (ret<0)
    perror("FILE_EndPoint::~FILE_EndPoint");
  assert(ret==0);

  return EP_OK;
}

int FILE_EndPoint::read(char*& buf, unsigned& nbytes) {
  // lets open the file
#ifdef VERBOSE
  std::cout << "waiting on '" << otherName << "'...\n";
#endif
  do {
    f.open(otherName,std::ios::in);
    if (!f) {
      int ret=usleep(FILE_EndPoint::SLEEP_TIME);
      assert(ret==0);
    }
  } while(!f);
#ifdef VERBOSE
  std::cout << "'" << otherName << "' is now available...\n";
#endif
  assert(f);

  struct stat fs;
  int ret=stat(otherName,&fs);
  assert(ret==0);
  nbytes=fs.st_size+1;
  buf=new char[nbytes];
  assert(ret==0);
  f.read(buf,nbytes-1);
  if (f.fail()) {
    ret=unlink(otherName);
    assert(ret==0);
    return EP_READ_ERROR;
  }
  buf[nbytes-1]='\0';

  // lets close/remove the file 
  f.close();
  if (f.fail())
    return EP_CLOSE_ERROR;
  ret=unlink(otherName);
  assert(ret==0);
  return EP_OK;
}

void FILE_EndPoint::exportData(const doubleArray& a) {
  std::strstream ostr;
//  a.display("EP_Interpolator::exportData()");
  unsigned ndim=a.numberOfDimensions();
  assert(ndim==1 || ndim==2);
  if (ndim==1) {
    std::cerr << "not implemented\n";
    assert(0);
    int i;
    for(i=a.getBase(0);i<=a.getBound(0);i+=a.getStride(0)) {
      std::cout << i << ": " << a(i) << endl;
    }
  }
  else if (ndim==2) {
    int i, j;
#ifdef DEBUG
    std::cout << a.getBase(0) << " " << a.getBound(0) << endl;
    std::cout << a.getBase(1) << " " << a.getBound(1) << endl;
#endif
    // number of dimensions, number of elements
    // coordinate, element
    ostr << ndim << " " << a.elementCount() << std::endl;
    for(i=a.getBase(0);i<=a.getBound(0);i+=a.getStride(0)) {
      for(j=a.getBase(1);j<=a.getBound(1);j+=a.getStride(1)) {
#ifdef DEBUG
        std::cout << i << "," << j << ": " << a(i,j) << endl;
#endif
        ostr << i << " " << j << " " << a(i,j) << std::endl;
      }
    }
  }
  int ret=write(ostr.str(),ostr.pcount());
  assert(ret==EndPoint::EP_OK);
}

void FILE_EndPoint::importData(const doubleArray& a) {
  char* buf;
  unsigned nbytes;
  int ret=read(buf,nbytes);
  assert(ret==EndPoint::EP_OK);
  std::istrstream istr(buf,nbytes);
  unsigned ndim, nelem;
#ifdef DEBUG
  std::cout << istr.str() << endl;
#endif
  istr >> ndim >> nelem;
  // let's make sure things are of the same size
//  std::cout << "Let's see: " << ndim << " " << a.numberOfDimensions() << " " << nelem << " " << a.elementCount() << endl;
  assert(ndim==static_cast<unsigned>(a.numberOfDimensions()) && 
         nelem==static_cast<unsigned>(a.elementCount()));
  int i, j;
  unsigned nreadElem=0;
  for(i=a.getBase(0);i<=a.getBound(0);i+=a.getStride(0)) {
    for(j=a.getBase(1);j<=a.getBound(1);j+=a.getStride(1)) {
      int coord_i, coord_j;
      double v;
      istr >> coord_i >> coord_j >> v;
      assert(!istr.fail());
#ifdef DEBUG
      std::cout << coord_i << " " << coord_j << endl;
#endif
      a(i,j)=v;
      nreadElem++;
    }
  }
  assert(nreadElem==nelem);
  delete[] buf;
}

FILE_EndPoint::~FILE_EndPoint() {
}
