// Henrique Andrade - March 2003
// University of Maryland, College Park
//
// Class Description:
// 
// This is an abstract class for a MetaChaos endpoint. It implements the
// abstract methods described in the EndPoint class.

#ifndef IC_ENDPOINT_H
#define IC_ENDPOINT_H

#include "EndPoint.h"
#include <stdio.h>

#ifdef PPLUSPLUS
#include <A++.h>
#endif

#ifdef FORTRAN90
#include "carray_descriptor.h"
#endif

class IC_EndPoint : public EndPoint {
  public:
    enum {
      IC_TAG          = 1,
      IC_COLUMN_MAJOR = 1,
      IC_ROW_MAJOR    = 2,

// the declarations below must be in sync with
// ../FortranInterface/intercomm_interface.h
      IC_OK                         =   0,
      IC_GENERIC_ERROR              =  -1,
      IC_INVALID_NDIM               =  -2,
      IC_CANT_ALLOC_REGION          =  -3,
      IC_CANT_GET_DA_DESCRIPTOR     =  -4,
      IC_CANT_COMPUTE_COMM_SCHEDULE =  -5,
      IC_COMM_FAILURE               =  -6,
      IC_INVALID_ENDPOINT_NAME      =  -7,
      IC_INITIALIZATION_FAILURE     =  -8,
      IC_CANT_CONNECT_TO_REMOTE     =  -9,
      IC_PVM_ERROR                  = -10,
      IC_MPI_ERROR                  = -11,
      IC_POINTER_TABLE_ERROR        = -12
    };
    static const char * const IC_errors[];
    // to create a communication endpoint, one needs to name it (the format is
    // "thisprogram'sname::otherprogram'sname"), define how many processors
    // this program uses, as well as the other program, and define the array
    // order used for this program as well as the other program
    IC_EndPoint(const char* endpointName, const unsigned mynproc,
        const unsigned onproc, const unsigned myao, 
        const unsigned oao, int& status);
#ifdef PPLUSPLUS
    virtual void exportArray(const intArray&, int&);
    virtual void importArray(const intArray&, int&);
    virtual void exportArray(const floatArray&, int&);
    virtual void importArray(const floatArray&, int&);
    virtual void exportArray(const doubleArray&, int&);
    virtual void importArray(const doubleArray&, int&);
#endif
#ifdef FORTRAN90
    virtual void exportArray(const F90_charArray&, int&);
    virtual void importArray(const F90_charArray&, int&);
    virtual void exportArray(const F90_shortArray&, int&);
    virtual void importArray(const F90_shortArray&, int&);
    virtual void exportArray(const F90_intArray&, int&);
    virtual void importArray(const F90_intArray&, int&);
    virtual void exportArray(const F90_floatArray&, int&);
    virtual void importArray(const F90_floatArray&, int&);
    virtual void exportArray(const F90_doubleArray&, int&);
    virtual void importArray(const F90_doubleArray&, int&);
#endif
    static void printErrorMessage(const char* msg, const int ic_err);
    virtual ~IC_EndPoint();
  protected:
#ifdef FORTRAN90
    IC_Desc* buildDescriptor(const F90_charArray& a);
    IC_Desc* buildDescriptor(const F90_shortArray& a);
    IC_Desc* buildDescriptor(const F90_intArray& a);
    IC_Desc* buildDescriptor(const F90_floatArray& a);
    IC_Desc* buildDescriptor(const F90_doubleArray& a);
#endif
    // information needed by InterComm to carry out the communication
    // pointers to the data structures describing the local and remote
    // communication endpoints
    IC_Program *otherProgram;
    unsigned thisProgramAO, otherProgramAO;
    // static stuff
    static IC_Program *thisProgram;
    static unsigned nendpoints;
};

// these functions added for creating arrays in P++, then using the objects in Fortran
#ifdef PPLUSPLUS
int IC_Create_bdecomp_desc(intArray& a);
int IC_Create_bdecomp_desc(floatArray& a);
int IC_Create_bdecomp_desc(doubleArray& a);
#endif

#endif
