/* 
 * File: schedule.h
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: functions for communication schedules.
 *       Some functions from Meta-Chaos.
 * Date: Feb. 2004
 */

#ifndef SCHEDULE_H
#define SCHEDULE_H

#include "intercomm.h"
#include "pgme.h"


typedef IC_Sched sched_s;

void sendScheduleLocal();
void sendSchedule(sched_s**, sched_s**, pgme_s*, pgme_s*);
void sendScheduleToPgme(sched_s**, pgme_s*);
void sendScheduleTableToOneNode(sched_s**, pgme_s*, int);


sched_s *ReceiveSchedules(pgme_s*, pgme_s*);
sched_s *ReceiveSchedule(pgme_s*);
sched_s *ReceiveScheduleReverseOrder(pgme_s*);
sched_s** ReceiveScheduleTab(pgme_s*, int);


sched_s** merge_schedules(sched_s***, int, pgme_s*, pgme_s*);
sched_s* Receive_Distribute_Schedules(pgme_s*, pgme_s*, int);

sched_s *CreateSched(int);
sched_s **CreateTabScheds(int, int);
sched_s *AddSched(sched_s*, int, int, int);
sched_s *AddSchedLast(sched_s*, int, int, int);


void FreeSched(sched_s*);
void FreeTabScheds(sched_s**, int);
void PrintSched(sched_s*);
void PrintSched1(sched_s*);

#endif /* SCHEDULE_H */
