#!/bin/sh

pvmdir=$HOME/pvm3/bin/$PVM_ARCH
mkdir -p $pvmdir
cp ctest_west ctest_east ctest_north ctest_south $pvmdir
echo "quit" | pvm > /dev/null
if test $? -eq 1; then
  exit 1
fi

$pvmdir/ctest_west &
west=$!
$pvmdir/ctest_east &
east=$!
$pvmdir/ctest_north &
north=$!
$pvmdir/ctest_south &
south=$!

wait $west
if test $? -ne 0; then
  exit 1
fi
wait $east
if test $? -ne 0; then
  exit 1
fi
wait $north
if test $? -ne 0; then
  exit 1
fi
wait $south
if test $? -ne 0; then
  exit 1
fi

ps -u $USER -o pid,comm | grep pvmd3 > /tmp/pkill
pid=`awk '{ print $1 }' /tmp/pkill`
kill -TERM $pid
exit 0
