c
c     commonfstartup
c
      subroutine commonfstartup(argv, r, sts)
      implicit none
      include 'ftest.h'

      character*10 argv
      integer r, sts

      character*4 groupname
      character*4 othername
      character*4 thirdname
      common /BLOCK1/ groupname, othername, thirdname

      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third
      
      integer p, info

      sts = 0

c     initialize PVM
      call pvmfstartup(argv, TASKS, p)
      if (p .LT. TASKS) then
         print *, 'need', TASKS, ' tasks'
         return
      end if
      call pvmfjoingroup(argv, r)
      if (r .LT. 0) then
         call pvmfperror('joingroup', r)
         return
      else
         call pvmfbarrier(argv, p, info)
         if (info .LT. 0) then
            call pvmfperror('barrier', info)
            return
         end if
      end if

c     initialize IC
      call ic_init(groupname, TASKS, r, this)
      if (this .LT. 0) then
         print *, 'error initializing program'
         return
      end if
      call ic_wait(othername, TASKS, other)
      if (other .LT. 0) then
         print *, 'error initializing other program'
         return
      end if      
      call ic_sync(this, other, info)
      if (info .LT. 0) then
         print *, 'error synchronizing programs'
         return
      end if
      call ic_wait(thirdname, TASKS, third)
      if (third .LT. 0) then
         print *, 'error initializing third program'
         return
      end if
      call ic_sync(this, third, info)
      if (info .LT. 0) then
         print *, 'error synchronizing programs'
         return
      end if
      
      sts = 1
      end

c
c     create_block_desc
c
      subroutine create_block_desc(d, r, sz, desc)
      implicit none
      include 'fblocks.h'

      integer d, r, sz(RANK), desc
      integer i, tk(TASKS)

      do i = 1, TASKS
         tk(i) = i - 1
      end do
      
      call ic_create_bdecomp_desc(RANK, BD(1,1,1,d), tk, TASKS, desc)
      if (desc .LT. 0) then
         print *, 'error creating descriptor'
         return 
      end if

      do i = 1, RANK
         sz(i) = (BD(r+1,2,i,d) - BD(r+1,1,i,d)) + 1
      end do
      
      end

c
c     create_table_desc
c     
      subroutine create_table_desc(t, r, desc)
      implicit none
      include 'ftables.h'
      
      integer t, r, sz, desc
      integer i, globals(SIZE)
      
      do i = 1, SIZE
         globals(i) = i + SIZE*r
      end do
      
      call ic_create_ttable_desc(globals, TT(1,2,r+1,t), TT(1,1,r+1,t), 
     $     SIZE, desc)
      if (desc .LT. 0) then
         print *, 'error creating descriptor'
         return
      end if
      
      end

c
c     initdarray
c
      subroutine initdarray(A, sx, sy, d, r)
      implicit none
      include 'fblocks.h'      

      integer sx, sy
      integer A(sx, sy), d, r      
      integer i, j
      
      do i = 1, sx
         do j = 1, sy
            A(i,j) = 10*(i+BD(r+1,1,1,d)-1) + (j+BD(r+1,1,2,d)-1)
         end do
      end do
      
      end

c
c     inittarray
c
      subroutine inittarray(A, t, r)
      implicit none
      include 'ftables.h'

      integer A(SIZE), t, r
      integer i, j

      do i = 1, TASKS
         do j = 1, SIZE
            if (r .EQ. TT(j,1,i,t)) then
               A(TT(j,2,i,t)) = j + (i-1)*SIZE
            end if
         end do
      end do

      end

c
c     senddregion
c
      subroutine senddregion(receiver, b, desc, A, sts)
      implicit none
      include 'fblocks.h'

      integer receiver, b, desc, A(*), sts

      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third
 
      integer regions(1)
      integer sched
      integer info
      
      sts = 0

      call ic_create_block_region(RANK, BX(1,1,1,b), 
     $     BX(1,2,1,b), BX(1,3,1,b), regions(1))      
      if (regions(1) .LT. 0) then
         print *, 'error creating send region'
         return
      end if
      
      call ic_compute_schedule(this, receiver, desc, regions, 1, sched)
      if (sched .LT. 0) then
         call ic_print_error('error creating schedule')
         return
      end if
      
      call ic_send_int(receiver, sched, A, 666, info)
      if (info .LT. 0) then
         print *, 'error on send'
         return
      end if
      
      call ic_sync(this, receiver, info)
      if (info .LT. 0) then
         print *, 'error synchronizing programs'
         return
      end if
      
      call ic_free_sched(sched)
      call ic_free_region(regions(1))
      
      sts = 1
      end

c
c     sendtregion
c
      subroutine sendtregion(receiver, e, desc, A, sts)
      implicit none
      include 'ftables.h'

      integer receiver, e, desc, A(*), sts

      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third
 
      integer regions(1)
      integer sched
      integer info
      
      sts = 0

      call ic_create_enum_region(TX(1,1,e), TS(e), regions(1))
      if (regions(1) .LT. 0) then
         print *, 'error creating send region'
         return
      end if

      call ic_compute_schedule(this, receiver, desc, regions, 1, sched)
      if (sched .LT. 0) then
         call ic_print_error('error creating schedule')
         return
      end if
      
      call ic_send_int(receiver, sched, A, 666, info)
      if (info .LT. 0) then
         print *, 'error on send'
         return
      end if
      
      call ic_sync(this, receiver, info)
      if (info .LT. 0) then
         print *, 'error synchronizing programs'
         return
      end if
      
      call ic_free_sched(sched)
      call ic_free_region(regions(1))
      
      sts = 1
      end
      
c
c     recvdregion
c
      subroutine recvdregion(sender, b, desc, A, sts)
      implicit none
      include 'fblocks.h'

      integer sender, b, desc, A(*), sts

      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third
      
      integer regions(1)
      integer sched
      integer info
     
      sts = 0

      call ic_create_block_region(RANK, BX(1,1,2,b), BX(1,2,2,b), 
     $     BX(1,3,2,b), regions(1))
      if (regions(1) .LT. 0) then
         print *, 'error creating send region'
         return
      end if
      
      call ic_compute_schedule(this, sender, desc, regions, 1, sched)
      if (sched .LT. 0) then
         print *, 'error creating schedule'
         return
      end if
      
      call ic_recv_int(sender, sched, A, 666, info)
      if (info .LT. 0) then
         print *, 'error on recv'
         return
      end if
      
      call ic_sync(this, sender, info)
      if (info .LT. 0) then
         print *, 'error synchronizing programs'
         return
      end if
      
      call ic_free_sched(sched)
      call ic_free_region(regions(1))

      sts = 1
      end

c
c     recvtregion
c
      subroutine recvtregion(sender, b, desc, A, sts)
      implicit none
      include 'ftables.h'

      integer sender, b, desc, A(*), sts
      
      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third
      
      integer regions(1)
      integer sched
      integer info
     
      sts = 0

      call ic_create_enum_region(TX(1,2,b), TS(b), regions(1))
      if (regions(1) .LT. 0) then
         print *, 'error creating send region'
         return
      end if

      call ic_compute_schedule(this, sender, desc, regions, 1, sched)
      if (sched .LT. 0) then
         print *, 'error creating schedule'
         return
      end if
      
      call ic_recv_int(sender, sched, A, 666, info)
      if (info .LT. 0) then
         print *, 'error on recv'
         return
      end if
      
      call ic_sync(this, sender, info)
      if (info .LT. 0) then
         print *, 'error synchronizing programs'
         return
      end if
      
      call ic_free_sched(sched)
      call ic_free_region(regions(1))

      sts = 1
      end

c
c     verifyfrecv
c
      integer function getdvalue(b, m)
      include 'fblocks.h'
      integer b, m, o

      integer LO,UP,ST
      parameter (LO = 1, UP = 2, ST = 3)
      integer SND,RCV
      parameter (SND = 1, RCV = 2)

      o = (BX(1,UP,SND,b)-BX(1,LO,SND,b)+1)/BX(1,ST,SND,b)
      getdvalue = ((m/o+BX(2,LO,SND,b)-1)*BX(2,ST,SND,b)+1)+ 
     $     10*((mod(m,o)+BX(1,LO,SND,b)-1)*BX(1,ST,SND,b)+1)

      end

      subroutine verifytrecv(sender, A, r, t, s, sts)
      implicit none
      include 'ftables.h'
      
      integer TSK,OFF
      parameter (TSK = 1, OFF = 2)
      integer SND,RCV
      parameter (SND = 1, RCV = 2)

      integer sender, A(SIZE), r, t, s, sts
      integer i, j, k, l, m, n, o

      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third

      integer getdvalue

      sts = 0

c     step through the global array
      do i = 1, TASKS
         do j = 1, SIZE
            
c     see if we're responsible for this index
            if (r .EQ. TT(j,TSK,i,t)) then
               do k = 1, TS(s)
                  
c     see if we're considering a destination index
                  if (j + (i-1)*SIZE .EQ. TX(k,RCV,s)) then
                     
c     see what descriptor type the other program uses
                     if (sender .EQ. other) then
                        l = TX(k,SND,s)
                        goto 10
                     else if (sender .EQ. third) then                        
                        l = getdvalue(s, k-1)
                        goto 10
                     else 
                        return
                     end if
                  else
                     l = j + (i-1)*SIZE
                  end if
               end do
 10            continue
               if (A(TT(j,OFF,i,t)) .NE. l) then
                  print *, 'got = ', A(TT(j,OFF,i,t)), ', wanted = ', l
                  return
               end if
            end if
         end do
      end do
      
      sts = 1
      end

      integer function gettvalue(s, m)
      include 'ftables.h'
      integer s, m

      integer TSK,OFF
      parameter (TSK = 1, OFF = 2)
      integer SND,RCV
      parameter (SND = 1, RCV = 2)

      gettvalue = TX(m,SND,s)

      end

      subroutine verifydrecv(sender, A, sx, sy, r, d, b, sts)
      implicit none
      include 'fblocks.h'

      integer LO,UP,ST
      parameter (LO = 1, UP = 2, ST = 3)
      integer SND,RCV
      parameter (SND = 1, RCV = 2)
      
      integer sx, sy
      integer sender, A(sx,sy), r, d, b, sts
      integer i, j, k, l, m, n, o

      integer this
      integer other
      integer third
      common /BLOCK2/ this, other, third

      integer gettvalue

      sts = 0
      
c     step though the global array
      do i = 1, DIMX
         do j = 1, DIMY

c     see if we're inside the local region (k & l are local coords)
            if ((i .GE. BD(r+1,LO,1,d) .AND. 
     $           i .LE. BD(r+1,UP,1,d)) .AND. 
     $           (j .GE. BD(r+1,LO,2,d) .AND. 
     $           j.LE.BD(r+1,UP,2,d))) then
               k = i - BD(r+1,LO,1,d) + 1
               l = j - BD(r+1,LO,2,d) + 1

c     see if we're inside the destination region (m is the linearization coord)
               if ((i .GE. BX(1,LO,RCV,b) .AND. 
     $              i .LE. BX(1,UP,RCV,b)) .AND. 
     $              (j .GE. BX(2,LO,RCV,b) .AND. 
     $              j .LE. BX(2,UP,RCV,b)) .AND. 
     $              (mod(i-BX(1,LO,RCV,b), BX(1,ST,RCV,b)) .EQ. 0) .AND. 
     $              (mod(j-BX(2,LO,RCV,b), BX(2,ST,RCV,b)) .EQ. 0)) then
                  o = (BX(1,UP,RCV,b)-BX(1,LO,RCV,b)+1)/BX(1,ST,RCV,b)
                  m = o*((j-BX(2,LO,RCV,b))/BX(2,ST,RCV,b))+
     $                 ((i-BX(1,LO,RCV,b))/BX(1,ST,RCV,b))

c     see what descriptor the other program uses
                  if (sender .EQ. other) then
                     o = (BX(1,UP,SND,b)-BX(1,LO,SND,b)+1)/ 
     $                    BX(1,ST,SND,b)
                     n = ((m/o+BX(2,LO,SND,b)-1)*BX(2,ST,SND,b)+1)+ 
     $                    10*((mod(m,o)+BX(1,LO,SND,b)-1)*
     $                    BX(1,ST,SND,b)+1)
                  else if (sender .EQ. third) then
                     n = gettvalue(b, m+1)
                  else
                     return
                  end if
               else
                  m = -1 
                  n = 10*i + j
               end if
               if (A(k,l) .NE. n) then
                  print *, 'globe = (', i, j, ' )'
                  print *, 'local = (', k, l, ' )'
                  print *, 'coord = (', m, ' )'
                  print *, 'got = ', A(k,l), ', wanted = ', n
                  return 
               end if
            end if
         end do
      end do

      sts = 1
      end
      
c
c     printfarray
c     
      subroutine printfarray(A, sx, sy)      
      implicit none
      include 'ftest.h'      
      
      integer sx, sy
      integer A(sx,sy)
      integer i, j

      do i = 1, sx
         print *, (A(i,j), j = 1, sy)
      end do
      
      end

c
c     printxfer
c
      subroutine printfxfer(x)
      implicit none
      include 'fblocks.h'
      integer x, i
      
      print *, 'SEND (', 
     $     (BX(i,1,1,x), i = 1, RANK), ' ) to (',
     $     (BX(i,2,1,x), i = 1, RANK), ' ) by (', 
     $     (BX(i,3,1,x), i = 1, RANK), ' )'

      print *, 'RECV (',
     $     (BX(i,1,2,x), i = 1, RANK), ' ) to (',
     $     (BX(i,2,2,x), i = 1, RANK), ' ) by (',
     $     (BX(i,3,2,x), i = 1, RANK), ' )'

      end 
