#!/bin/sh

pvmdir=$HOME/pvm3/bin/$PVM_ARCH
mkdir -p $pvmdir
cp ftest_west ftest_east ftest_nort ftest_sout $pvmdir
echo "quit" | pvm > /dev/null
if test $? -eq 1; then
  exit 1
fi

$pvmdir/ftest_west &
west=$!
$pvmdir/ftest_east &
east=$!
$pvmdir/ftest_nort &
north=$!
$pvmdir/ftest_sout &
south=$!

wait $west
if test $? -ne 0; then
  exit 1
fi
wait $east
if test $? -ne 0; then
  exit 1
fi
wait $north
if test $? -ne 0; then
  exit 1
fi
wait $south
if test $? -ne 0; then
  exit 1
fi

ps -u $USER -o pid,comm | grep pvmd3 > /tmp/pkill
pid=`awk '{ print $1 }' /tmp/pkill`
kill -TERM $pid
exit 0
