#include "boolean.h"
#include "compute_schedule.h"
#include "region.h"
#include "pgme.h"
#include "schedule.h"
#include "chaos2ttable.h"
#include "common.h"
#include <stdio.h>

#define INIT_MSG 2000
#define CH_DIM 1048576 /* I allocate the maximum size */


extern int  PARTI_numnodes;		/* number of processors */
extern int  PARTI_mynode;		/* processor id */
extern int  PARTI_pid;			/* process id */

int main(int nb_arg,char **arg)
{
  char *pgme_name = "Pgme2";
  char *other_pgme_name = "Pgme1";

  int OverAllSize;
  int ii, jj;
  pgme_s *my_pgme;
  pgme_s *other_pgme;
  int numNode_other;
  int me = -1;
  int numNode = -1;
  TTABLE *CH_ttable;
  double *CH_array;
  int i, j, k;
  region_s *r;
  setOfRegion_s *CH_Set;
  boolean compute_remapping = true;
  boolean new_iteration = true;
  sched_s *sched;
  int CH_IndexSize; /* Chaos ttable */
  int *CH_Index;    /* Chaos ttable */
  int numproc;
  int IterationCounter = 0;
  int SetRegionOverAllSize;
  char mesh_name[100];
  int *edge_left; 
  int *edge_right;
  int number_edges;
  int garb1, garb2;
  int gb1, gb2;
  simple_ttable* s_table;
  int pn;
  
  int aaa[17] = {
    0,
    21052,
    193088,
    200247,
    244431,
    295238,
    329911,
    358402,
    512299,
    607279,
    618731,
    643600,
    719912,
    734740,
    750433,
    950753,
    1048576
  };
  
  int size[16] = {  
    7307,
    120099,
    2451,
    6902,
    15667,
    13760,
    15370,
    122529,
    10969,
    2919,
    23236,
    36429,
    3830,
    2709,
    121957,
    18154
  };
  
  int res;

  if (nb_arg < 3) {
    printf("Usage main1 #replicate #friends\n");
    exit(1);
  }

  numNode_other = atoi(arg[2]);
  
  if (numNode_other <= 0 || atoi(arg[1]) <= 0) {
    printf("Wrong value for one of the params\n");
    exit(1);
  }

  numNode = start_master_slave(arg);

  /*
   * Initialise 
   *    the pvm library
   *    the chaos library
   */
  parti_pvm_setup(numNode, 100, pgme_name);
  PARTI_setup();

  /*
   * Initialise the pgme structure 
   * who am i, who are the other nodes ...
   */
  my_pgme = InitPgme("Truc2", numNode);
  other_pgme = WaitPgme("Truc1", numNode_other);
  numproc = NumNodePgme(my_pgme);
  me = MyPosMyPgme();
  Sync2Pgme(my_pgme,other_pgme);

  /*
   * I do a maximum memory allocation for chaos indices (ia)
   */
  CH_IndexSize = 0;
  CH_Index = (int*)malloc(sizeof(int)*CH_DIM);

  /* 
   * create the translation table 
   */ 
  set_CH_indices(CH_DIM, CH_Index, &CH_IndexSize, my_pgme);
  CH_ttable = build_translation_table(1, CH_Index, CH_IndexSize); 
  s_table = translate_ttable(CH_ttable, numproc, me, CH_DIM);
  /*
  printf("SIMPLE table\n\n");

  printf("nData = %d\n", s_table->nData);

  printf("global low = %d\n", s_table->global_low_bound);
  printf("global high = %d\n", s_table->global_high_bound);
  
  for(i =0; i< s_table->nData; i++)
    {
      printf("global[%d] = %d\n", i, s_table->global_index[i]);
   printf("proc num[%d] = %d\n", i, s_table->proc_num[i]);
   printf("local offset[%d] = %d\n\n", i, s_table->local_offset[i]);

    }
  */

  /* 
   * I allocate the maximum size of the Chaos Array
   * and I initialise it to 0
   */
  CH_array = (double*)malloc(sizeof(double)*CH_DIM);
  InitDouble(CH_array, CH_DIM);
  {
    int i;
    for(i = 0; i < CH_DIM; i++) {
      /* when this is a sender */
      /* CH_array[i] = i* numproc + me; */      
      /* when this is a receiver */
      CH_array[i] = -9999.0;
    }
  }

  /*
   * create the SetOfRegion for Chaos
   */
  CH_Set = Alloc_setOfRegion();
  /*
    r = Alloc_RangeRegion(0, 10); 
   Add_Region_setOfRegion(r, CH_Set); 
   fprintf(stderr,"new region\n");
  */
/*   r = Alloc_RangeRegion(1, 10); */
/*   Add_Region_setOfRegion(r, CH_Set); */
  
/*   r = Alloc_RangeRegion(20, 5); */
/*   Add_Region_setOfRegion(r, CH_Set); */
  
  for(i = 0; i < 16; i++) {
    r = Alloc_RangeRegion(aaa[i] , size[i]);
    Add_Region_setOfRegion(r, CH_Set);
  }
  
  Init_PVM_routes(my_pgme, other_pgme);
  Sync2Pgme(my_pgme, other_pgme);

  start_timer_1(1);
  OverAllSize = SizeSetOfRegion(CH_Set);  
  sched = ComputeScheduleFor_Two_NonCompacts(Receiver, s_table, CH_Set, my_pgme, other_pgme);
  stop_timer(1);
  Sync2Pgme(my_pgme,other_pgme); 

  start_timer_1(2);
  dDataMoveRecv(other_pgme,sched,CH_array,1001);
  stop_timer(2);  
  Sync2Pgme(my_pgme,other_pgme);

  /*
    pn =13;
    
    {
    int count =0;
    FILE* OutFile;
    
    if (me==pn)
    {
    OutFile=fopen("/roguehomes/jylee/tempres/res.1","a");
     if (OutFile == NULL)
     {
     printf("\n /scratch1/jylee/resultats_Coupling2_2Pgme.1 not open \n");
     OutFile=stdout;
	 }
       
     }
   
   
   for (i=0; i< CH_DIM; i++) 
     {
       if(CH_array[i] != -9999.0)
	 {
	   count++;
	   if(me == pn)
	   fprintf(OutFile,"[%d]= %f ",i,CH_array[i]);
	   
	 }
     }
   if(me == pn) fclose(OutFile);
   printf("Count = %d me = %d\n",count,me);  
   } 
  */

  
  pn = 15;
  
  {
    int count = 0;
    
    for (i = 0; i < CH_DIM; i++) {
      if (CH_array[i] != -9999.0) {
	printf("ch_array[%d] = %f\n", i, CH_array[i] );
	count++;
      }
    }
    
    printf("Count = %d me = %d\n", count, me); 
  }
  
  printf("\n I am the process %d in main1\n", me); 
  
  {
    FILE *OutFile;
    
    FILE *fp_max_scheds;
    FILE *fp_avg_scheds;
    
    FILE *fp_max_move;
    FILE *fp_avg_move;
    
    int min1, my1, max1, avg1;
    int min2, my2, max2, avg2;

    if (me == 0) {
      OutFile = fopen("/tmp/result_chch.1","a");
      if (OutFile == NULL) {
	printf("\n /tmp/result_chch.1 not open \n");
	OutFile = stdout;
      }
      
      fp_max_scheds = fopen("/tmp/max_sched.1","a");
      if (fp_max_scheds == NULL) {
	printf("\n /tmp/max_sched.1 not open \n");
	fp_max_scheds=stdout;
      }
      
      fp_avg_scheds = fopen("/tmp/avg_sched.1","a");
      if (fp_avg_scheds == NULL) {
	printf("\n /tmp/avg_sched.1 not open \n");
	fp_avg_scheds=stdout;
      }
      
      fp_max_move = fopen("/tmp/max_move.1","a");
      if (fp_max_move == NULL) {
	printf("\n /tmp/max_move.1 not open \n");
	fp_max_move=stdout;
      }
      
      fp_avg_move = fopen("/tmp/avg_move.1","a");
      if (fp_avg_move == NULL) {
	printf("\n /tmp/avg_move.1 not open \n");
	fp_avg_move = stdout;
      }
    }
    else {
      OutFile = stdout;
    }

    fprintf(OutFile,"\n-------------------------------------");
    fprintf(OutFile,"\n CH to CH (main1)..............");
    fprintf(OutFile,"\n me %i ",me);
    fprintf(OutFile,"\n numproc %i ",NumNodePgme(my_pgme));
    fprintf(OutFile,"\n numproc_other %i ",NumNodePgme(other_pgme));
    fprintf(OutFile,"\n Niter   ",IterationCounter);
    fprintf(OutFile,"\n Timers ");
    
    min1 = return_timer_min(1) ;
    my1 = return_timer(1) ;
    max1 = return_timer_max(1) ;
    avg1 = return_timer_avg(1) ;

    min2 = return_timer_min(2) ;
    my2 = return_timer(2) ;
    max2 = return_timer_max(2) ;
    avg2 = return_timer_avg(2) ;

    fprintf(OutFile,"\n                        =      min     mine    max     avg", min1, my1, max1, avg1);
    fprintf(OutFile,"\n Compute Sched CH -> CH = %8i %8i %8i %8i", min1, my1, max1, avg1);
    fprintf(OutFile,"\n remap                  = %8i %8i %8i %8i", min2, my2, max2, avg2);
    fprintf(OutFile,"\n-------------------------------------");

    if (me == 0) {
      fprintf(fp_max_scheds,"\n%d", max1);
      fprintf(fp_max_move,"\n%d", max2);
      
      fprintf(fp_avg_scheds,"\n%d", avg1);
      fprintf(fp_avg_move,"\n%d", avg2);
    }
    
    fclose(OutFile);
    
    if(me == 0) {
      fclose(fp_max_scheds);
      fclose(fp_avg_scheds);
      fclose(fp_max_move);
      fclose(fp_avg_move);
    }
  }
  
  Sync2Pgme(my_pgme,other_pgme);
  
  if (me == 0) 
    pvm_exit();
  
  printf("\n Finished normally, me = %d(main1) \n", me);
}
