#include "boolean.h"
#include "compute_schedule.h"
#include "region.h"
#include "pgme.h"
#include "schedule.h"
#include "chaos2ttable.h"
#include "mbp2bdecomp.h"
#include "common.h"
#include <stdio.h>

#define INIT_MSG 2000
#define CH_DIM 1048576 

int main(int nb_arg,char **arg)
{
  int gb1,gb2;
  char *pgme_name="Pgme1";
  char *other_pgme_name="Pgme2";
  pgme_s *my_pgme;
  pgme_s *other_pgme;
  int numNode_other;
  int me=-1;
  int numNode=-1;

  TTABLE *CH_ttable;

  double *CH_array;

  int i,j,k;
  int ii,jj;

  region_s *r;
  
  setOfRegion_s *CH_Set;

  boolean compute_remapping=true;
  boolean new_iteration    =true;

 
  sched_s *sched;
  int  CH_IndexSize; /* Chaos ttable */
  int *CH_Index    ; /* Chaos ttable */
  int numproc;
  int IterationCounter=0;

  int OverAllSize;

  char mesh_name[CH_DIM];
  int *edge_left; 
  int *edge_right;
  int number_edges;

  int res;

  simple_ttable* s_table;

  if (nb_arg < 3) {
    printf("Usage main1 #replicate #friends\n");
    exit(1);
  }
  numNode_other=atoi(arg[2]);
  if (numNode_other <= 0 || atoi(arg[1]) <= 0) {
    printf("Wrong value for one of the params\n");
    exit(1);
  } 

   numNode=start_master_slave(arg);
  //  numNode=start_master_slave(arg);
  //fprintf(stderr,"After start\n");
  
  /*
   ** Initialise 
   **    the pvm library
   **    the chaos library
   */
  parti_pvm_setup(numNode,100,pgme_name);
  //fprintf(stderr,"after pvm setup\n");
  PARTI_setup();
  //fprintf(stderr,"after setup\n");

  /*
   ** pvm inquiries
   */
  printf("\n me=%i ",me);
  /*
   ** Initialise the pgme structure 
   ** who am i, who are the other nodes ...
   */
  
  //fprintf(stderr,"main2 %d Bef init %d %d\n", me,numNode,numNode_other);
  my_pgme=InitPgme("Truc1",numNode);
  //fprintf(stderr,"main2 %d Bef wait\n", me);
  other_pgme=WaitPgme("Truc2",numNode_other);
  //printf("main2 %d Aft wait\n", me);
  numproc= NumNodePgme(my_pgme);
  
  me=MyPosMyPgme();
  //printf("\n Here me=%i ",me);
  init_timers();
  Sync2Pgme(my_pgme,other_pgme);

  fprintf(stderr,"main2 %d Initialized\n", me);
  /*
  ** I do a maximum memory allocation for chaos indices (ia)
  */
  CH_IndexSize=0;
  CH_Index=(int *)malloc(sizeof(int)*CH_DIM);
  /* 
  ** create the translation table 
  */ 
  set_CH_indices(CH_DIM,CH_Index,&CH_IndexSize,my_pgme);
  CH_ttable=build_translation_table(1,CH_Index,CH_IndexSize); 
  //printf("CCCCCCCCCCCCCCCCCCC %d \n\n",CH_IndexSize);

  // simplified translation table
  s_table =translate_ttable(CH_ttable, numproc, me, CH_DIM);
 
  /* 
   ** I allocate the maximum size of the Chaos Array
   ** and I initialise it to 0
   */
  CH_array=(double *)malloc(sizeof(double)*CH_DIM);
  InitDouble(CH_array,CH_DIM);
  
  
 
  /* Initialization */

  for (i=0; i< CH_DIM; i++)
    {
      // when Chaos is a sender
          CH_array[i] = i* numproc + me;
      
      // when  Chaos is a receiver
      //CH_array[i] = -9999.0;
    }
  
  
  /*
  ** create the SetOfRegion for Chaos
  */
  CH_Set=Alloc_setOfRegion();

  /*
    ///////// Simple example(has just one region /////
   // region 1
  r=Alloc_RangeRegion(1,16);
  Add_Region_setOfRegion(r,CH_Set);

  */


    // 14X14, 4 regions, a complex ex(for correctness), size=73

  r=Alloc_RangeRegion(1,7);
  Add_Region_setOfRegion(r,CH_Set);
  r=Alloc_RangeRegion(42,30);
  Add_Region_setOfRegion(r,CH_Set);
  r=Alloc_RangeRegion(17,23);
  Add_Region_setOfRegion(r,CH_Set);
  r=Alloc_RangeRegion(409,13);
  Add_Region_setOfRegion(r,CH_Set);


  /*
  // half data
  //    1024X1024, 16 regions
 
  // region 1
  r=Alloc_RangeRegion(1,30000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 2
  r=Alloc_RangeRegion(40000,50000);
  Add_Region_setOfRegion(r,CH_Set);

  // region 3
  r=Alloc_RangeRegion(140000,10000); 
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 4
  r=Alloc_RangeRegion(160000,10000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 5 
  r=Alloc_RangeRegion(200000,50000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 6  
  r=Alloc_RangeRegion(300000,50000); 
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 7
  r=Alloc_RangeRegion(400000,40000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 8
  r=Alloc_RangeRegion(450000,30000);
  Add_Region_setOfRegion(r,CH_Set);

  // region 9
  r=Alloc_RangeRegion(500000,20000); 
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 10
  r=Alloc_RangeRegion(530000,20000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 11  
  r=Alloc_RangeRegion(600000,10000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 12 
  r=Alloc_RangeRegion(620000,90000); 
  Add_Region_setOfRegion(r,CH_Set);
   
  // region 13
  r=Alloc_RangeRegion(800000,30000);
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 14
  r=Alloc_RangeRegion(850000,70000);
  Add_Region_setOfRegion(r,CH_Set);

  // region 15
  r=Alloc_RangeRegion(950000,4288); 
  Add_Region_setOfRegion(r,CH_Set);
  
  // region 16
  r=Alloc_RangeRegion(990000,10000);
  Add_Region_setOfRegion(r,CH_Set);
  
  */
  /*
    // Enumerated region

    r=Alloc_R_Enum(NumElem,globalCoord,distribution,mem_type);
    NumElem = 5;
    globalCoord  = {1,2,5,33,7};   
    distribution = R_replicated;
    mem_type     = Mem_Copy;
 

    Add_Region_setOfRegion(r,CH_Set);
  */


  /************************************************/
  // send/receive garbage messages to/from my pgme and other pgme(all nodes involved). to eliminate the overhead of first message passing on pvm.

  Init_PVM_routes(my_pgme,other_pgme);

 
  Sync2Pgme(my_pgme,other_pgme); 
  
  start_timer_1(1);

  OverAllSize = SizeSetOfRegion(CH_Set);
  //fprintf(stderr,"Overall size(CH) =%d\n", OverAllSize);

   
  /***********************New Compute Schedules *****************/
  
  //fprintf(stderr,"New compute schedule main2(%d)\n",me); 

  // Both MB and Chaos sides compute schedules..
  // 2 cases depending on sending a DD 
  // SendBack option ignored.. 
 
  //  sched = ComputeScheduleOnNonCompact_Mixed_Both( SendAllToAll,s_table,CH_Set,my_pgme,other_pgme);
  
  //sched = ComputeScheduleOnNonCompact_Mixed_Both(SendOneToOne,s_table,CH_Set,my_pgme,other_pgme);
  

  // Only Chaos side computes schedules..
  // 4 cases depending on sending a DD and receiving schedules

  // all nodes are responsible for some other nodes to send dd
   sched = ComputeScheduleOnNonCompact_Mixed( SendAllToAll,SendBackAll,s_table,CH_Set,my_pgme,other_pgme);
  
  // sched = ComputeScheduleOnNonCompact_Mixed( SendAllToAll,SendBackPart,s_table,CH_Set,my_pgme,other_pgme);
  
  
  // a repr node sends and receive a dd
  
  //sched = ComputeScheduleOnNonCompact_Mixed( SendOneToOne,SendBackAll,s_table,CH_Set,my_pgme,other_pgme);
  

  //sched = ComputeScheduleOnNonCompact_Mixed( SendOneToOne,SendBackPart,s_table,CH_Set,my_pgme,other_pgme);
  
 
  // Old compute-schedule 

  /*    
  // When chaos is a receiver
  sched=ComputeScheduleForReceiver
     
     (ComputeOnReceiver,
     my_pgme,
     CH_ttable,
     CH_Set,
     other_pgme,
     Chaos_Dereference_Offset_EnumSetOfRegion_Global,
     DoNotOptComm); 
  */

  

  // when CH is a sender
  /*
     sched=ComputeScheduleForSender
     
     (ComputeOnReceiver,
     my_pgme,
     CH_ttable,
     CH_Set,
     other_pgme,
     Chaos_Dereference_EnumRegion_Local,
     CHAOS_DistributeRegularly,
     &OverAllSize,
     DoNotOptComm); 
  */
  
  

  ///// Print schedules..
  /*
    fprintf(stderr," me = %d ---- (Old)print schedules(main2)(CH.send)\n\n", me);
    PrintSched(sched);
    fprintf(stderr," me = %d ---- (Old)End of print schedules(main2.CH.send)\n\n", me);
    
  */   

   //   fprintf(stderr,"After compute sched\n");
  stop_timer(1);
  
  
  Sync2Pgme(my_pgme,other_pgme); 
  start_timer_1(2);
  
  
  /*************************************/
  // Data move
  
  // Sender
  
  dDataMoveSend(other_pgme,sched,CH_array,1001);
  
  
  // Receiver
  
  // dDataMoveRecv(other_pgme,sched,CH_array,1001);     
  	
    
  /*
  // print received data
  
  //    for(i =0; i < CH_DIM; i++)
  for(i =0; i < 1000; i++)
  {
    if(CH_array[i] != -9999.0)
    fprintf(stderr,"CH[%d] = %f\n", i, CH_array[i]);
  }
  */
  
  stop_timer(2);
  
  Sync2Pgme(my_pgme,other_pgme);
  
  printf("\n I am the process %d in main2\n",me);
  FreeSimpleTable(s_table);
  
    {
      FILE *OutFile;

      FILE *fp_max_scheds;
      FILE *fp_avg_scheds;
      
      FILE *fp_max_move;
      FILE *fp_avg_move;
    
      int min1,my1,max1,avg1;
      int min2,my2,max2,avg2;

      if (me==0)
      {
	OutFile=fopen("/tmp/result_mb2ch.2","a");
	if (OutFile == NULL)
	  {
	    printf("\n /tmp/result_mb2ch.2 not open \n");
	    OutFile=stdout;
	  }
	
	fp_max_scheds = fopen("/tmp/max_sched.CH.2","a");
        if (fp_max_scheds == NULL)
          {
            printf("\n /tmp/max_sched.CH.2 not open \n");
            fp_max_scheds=stdout;
          }

        fp_avg_scheds = fopen("/tmp/avg_sched.CH.2","a");
        if (fp_avg_scheds == NULL)
          {
            printf("\n /tmp/avg_sched.CH.2 not open \n");
            fp_avg_scheds=stdout;
          }
	
        fp_max_move = fopen("/tmp/max_move.CH.2","a");
        if (fp_max_move == NULL)
          {
            printf("\n /tmp/max_move.CH.2 not open \n");
            fp_max_move=stdout;
          }

        fp_avg_move = fopen("/tmp/avg_move.CH.2","a");
        if (fp_avg_move == NULL)
          {
            printf("\n /tmp/avg_move.CH.2 not open \n");
            fp_avg_move=stdout;
          }
      }
    else
      OutFile=stdout;
    
    fprintf(OutFile,"\n-------------------------------------");
    fprintf(OutFile,"--- Chaos Side ------\n");
    fprintf(OutFile,"\n me %i ",me);
    fprintf(OutFile,"\n numproc %i ",NumNodePgme(my_pgme));
    /* fprintf(OutFile,"\n Niter   ",IterationCounter); */
    fprintf(OutFile,"\n Timers ");


    min1=return_timer_min(1) ;
    my1=return_timer(1) ;
    max1=return_timer_max(1) ;
    avg1=return_timer_avg(1) ;

    min2=return_timer_min(2) ;
    my2=return_timer(2) ;
    max2=return_timer_max(2) ;
    avg2=return_timer_avg(2) ;

    fprintf(OutFile,"\n Compute Sched Chaos -> MB = %8i %8i %8i %8i",
            min1,my1,max1,avg1);
    fprintf(OutFile,"\n remap                  = %8i %8i %8i %8i",
	    min2,my2,max2,avg2);

    fprintf(OutFile,"\n-------------------------------------");

    if(me ==0)
      {
	fprintf(fp_max_scheds,"\n%d",max1);
	fprintf(fp_max_move,"\n%d",max2);
	
	fprintf(fp_avg_scheds,"\n%d",avg1);
	fprintf(fp_avg_move,"\n%d",avg2);
      }

    fclose(OutFile);

    if(me ==0){
      fclose(fp_max_scheds);
      fclose(fp_avg_scheds);
      fclose(fp_max_move);
      fclose(fp_avg_move);
    }


    }

    Sync2Pgme(my_pgme,other_pgme);
    if(me==0)pvm_exit();
    
    printf("\n Finished normally, me = %d(main2,Chaos) \n",me);

}



