#include "boolean.h"
#include "compute_schedule.h"
#include "region.h"
#include "pgme.h"
#include "schedule.h"
#include "chaos2ttable.h"
#include "mbp2bdecomp.h"
#include "common.h"
#include <stdio.h>

#define INIT_MSG 2000

int main(int nb_arg,char **arg)
{
  int summ = 0;
  char *pgme_name="Pgme2";
  char *other_pgme_name="Pgme1";
  pgme_s *my_pgme;
  pgme_s *other_pgme;
  int numNode_other;
  int me=-1;
  int numNode=-1;

  DARRAY *BP_da    ;
  int BP_DIM1, BP_DIM2, BP_DIM3;

  double *BP_array;
  int gb1,gb2;
  int i,j,k;
  int size[BP_Ndim]; 
  
  region_s *r;
  setOfRegion_s *BP_Set;
  
  
  int left[BP_Ndim];
  int right[BP_Ndim];
  int stride[BP_Ndim];
  int numproc;
  int da_size[BP_Ndim];

  boolean compute_remapping=true;
  boolean new_iteration    =true;
  

  sched_s *sched;

  decomp_Birreg* irr_dd;
  
  int IterationCounter=0;
  
  int SetRegionOverAllSize;
  int OverAllSize;

  int LZ_count;
  
  // BP_DIM1 = BP_DIM2 = BP_DIM3=  4;

  BP_DIM1 = 16;
  BP_DIM2 = 27;
  BP_DIM3 = 6;

if (nb_arg < 3) {
    printf("Usage main1 #replicate #friends\n");
    exit(1);
  }
 
  numNode_other= atoi(arg[2]);
  if (numNode_other <= 0 || atoi(arg[1]) <= 0) {
    printf("Wrong value for one of the params\n");
    exit(1);
  }
  
  numNode=start_master_slave(arg);

  /*
   ** Initialise 
   **    the pvm library
   **    the chaos library
   */
  parti_pvm_setup(numNode,100,pgme_name);
  // fprintf(stderr,"after pvm setup\n");
  PARTI_setup();
  //fprintf(stderr,"after setup\n");
  
  /*
  ** Initialise the pgme structure 
  ** who am i, who are the other nodes ...
   */
  
  my_pgme=InitPgme("Truc2",numNode);
  //fprintf(stderr,"after init mypgme %d %d\n",numNode, numNode_other);
  other_pgme=WaitPgme("Truc1",numNode_other);
  //fprintf(stderr,"after wait other pgme\n");

  /*
  ** pvm inquiries
  */
  numproc = NumNodePgme(my_pgme);
  me=MyPosMyPgme();
  printf("\n me(main1)=%i ",me);
  
  init_timers();
  Sync2Pgme(my_pgme,other_pgme);
  fprintf(stderr,"main1 %d Initialized\n", me);
  
  /*
   ** Create a DAD for Block Parti
   */
  
  BP_da=BP_create_darray3(BP_DIM1, BP_DIM2, BP_DIM3);
  
  /*
   ** Allocate and initialize the BP_array
   */
  laSizes(BP_da,da_size);

  printf("Returned !!!!!!!!!!!!!!!!!!!!!%d %d %d\n", da_size[0], da_size[1], da_size[2]);  
  
  BP_array=(double *) malloc(sizeof(double)*da_size[0]*da_size[1]*da_size[2]);

  irr_dd = DARRAY2BirregTree(BP_da);
  
  /* Initialize : to make sure that areas not in regions doesn't change */

  // initialize when MB is a receiver
  
  {
    int i;
    for (i=0; i<da_size[0]*da_size[1]*da_size[2]; i++)
      BP_array[i] = -9999.0;
  }
  
  /*
  // initialize when MB is a sender..

  Initialize_distributed_array3(irr_dd,BP_array,BP_DIM1,BP_DIM2,BP_DIM3);


  /*
  ** create the SetOfRegion for BP
  */
  BP_Set=Alloc_setOfRegion();
  LZ_count = 0;


  //////////////////////// REGIONS ///////////////////////
   /********************** 1 region  ***********************/
  /*
    // 4X4X4

    left [0]=0         ; left[1]=0          ; left[2]=0             ; 
    right[0]=3 ;         right[1]= 3;         right[2] = 3;
    stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
    
 
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  */


  
  
  /********************** 3 regions  ***********************/
   
  // 16x27x6

  left [0]=1         ; left[1]=3          ; left[2]=2             ; 
  right[0]=1 ;         right[1]= 20;         right[2] = 3;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  /* 
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3);
  */
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  


    
  left [0]=2         ; left[1]=5          ; left[2]=0             ; 
  right[0]=7 ;         right[1]= 8;         right[2] = 5;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  /*
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3); 
  */
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);
  



  left [0]=5         ; left[1]=18          ; left[2]=3             ; 
  right[0]=15 ;         right[1]= 25;         right[2] = 4;
  stride[0]=1        ; stride[1]=1        ; stride[2] = 1;
  /*
  if(me == 0)
    LZ_count = Print_LZ_Info_3D(left,right,stride, LZ_count, BP_DIM1, BP_DIM2, BP_DIM3); 
  */
  r=Alloc_R_HPF(3,left,right,stride,R_replicated,Mem_Copy);
  Add_Region_setOfRegion(r,BP_Set);


 /*****************************************************************/
 
 Init_PVM_routes(my_pgme,other_pgme);


 Sync2Pgme(my_pgme,other_pgme); 
 
 start_timer_1(1);
 
  OverAllSize=SizeSetOfRegion(BP_Set);
   /***********************New Compute Schedules *****************/
  
  //fprintf(stderr,"New compute schedule main1(%d)\n",me); 

  // Both MB and Chaos sides compute schedules..
  // 2 cases depending on sending a DD 
  // SendBack option ignored..

  //sched =ComputeScheduleOnCompact_Mixed_Both(SendAllToAll,irr_dd,BP_Set,my_pgme,other_pgme);
  
  //sched =ComputeScheduleOnCompact_Mixed_Both( SendOneToOne,irr_dd,BP_Set,my_pgme,other_pgme);
  


  // Only Chaos side computes schedules..
  // 4 cases depending on sending a DD and receiving schedules
  // all nodes are responsible for some other nodes

      sched = ComputeScheduleOnCompact_Mixed(SendAllToAll,SendBackAll,irr_dd,BP_Set,my_pgme,other_pgme);
  
  
  // sched = ComputeScheduleOnCompact_Mixed( SendAllToAll,SendBackPart, irr_dd,BP_Set,my_pgme,other_pgme);
  
  
   // a repr sends dd 
   
  //    sched = ComputeScheduleOnCompact_Mixed(SendOneToOne,SendBackAll,irr_dd,BP_Set,my_pgme,other_pgme);
  
  
  //sched = ComputeScheduleOnCompact_Mixed(SendOneToOne,SendBackPart, irr_dd,BP_Set,my_pgme,other_pgme);
  

    /*******************Old Compute Schedules *********************/
   
  // when MB is a sender..
  /*
    sched =ComputeScheduleForSender(ComputeOnReceiver,my_pgme,BP_da,BP_Set,other_pgme,BlockParti_Dereference_HPFRegion_Local,DistributeRegularly,&OverAllSize,DoNotOptComm);
    
  */
  /*
      
  // when MB is a receiver
  sched =ComputeScheduleForReceiver(ComputeOnReceiver,my_pgme,BP_da,BP_Set,other_pgme,BlockParti_Dereference_Offset_HPFSetOfRegion_Global,DoNotOptComm);
  
  */

  /////     Print schedules....
  /*
  
  fprintf(stderr," me = %d ---- (Old)print schedules(main1)(MB.receive)\n\n", me);
  PrintSched(sched);
  fprintf(stderr," me = %d ---- (Old)End of print schedules(main1.MB.receive)\n\n", me);
  */
  
  stop_timer(1);
  
  /*****************  Receive(Send) ***************************/
 
   
   Sync2Pgme(my_pgme,other_pgme); 
   start_timer_1(2);
       
   // Receiver
   
   dDataMoveRecv(other_pgme,sched,BP_array,1001);     
     
   
   // Sender
   
   // dDataMoveSend(other_pgme,sched,BP_array,1001);
   
   
   stop_timer(2);
   
   Sync2Pgme(my_pgme,other_pgme);

   
   /************************************************************/
   /* Printing local array after receiving */
   /*
     {
    int i;
    
    printf("me(main2)= %d array sizes %d %d\n",me , da_size[0], da_size[1],da_size[2]);
    
    for (i=0; i<da_size[0]*da_size[1]; i++)
      printf("El %d = %f\n", i, BP_array[i] );
  
    
      }
   */
   /************************************************************/
   
   /* Printing whole array after collecting data items */
   
   collect_print_whole_array(me, irr_dd, my_pgme, BP_DIM1, BP_DIM2, BP_DIM3, da_size, BP_array);


   printf("\n I am the process %d in main2\n",me);
   
   {
    FILE *OutFile;

    FILE *fp_max_scheds;
    FILE *fp_avg_scheds;

    FILE *fp_max_move;
    FILE *fp_avg_move;
    
    int min1,my1,max1,avg1;
    int min2,my2,max2,avg2;
  
    if (me==0)
      {
	OutFile=fopen("/tmp/result_mb2ch.1","a");
	if (OutFile == NULL)
	  {
	    printf("\n /tmp/result_mb2ch.1 not open \n");
	    OutFile=stdout;
	  }
	
	fp_max_scheds = fopen("/tmp/max_sched.MB.1","a");
        if (fp_max_scheds == NULL)
          {
            printf("\n /tmp/max_sched.MB.1 not open \n");
            fp_max_scheds=stdout;
          }

        fp_avg_scheds = fopen("/tmp/avg_sched.MB.1","a");
        if (fp_avg_scheds == NULL)
          {
            printf("\n /tmp/avg_sched.MB.1 not open \n");
            fp_avg_scheds=stdout;
          }
	
        fp_max_move = fopen("/tmp/max_move.MB.1","a");
        if (fp_max_move == NULL)
          {
            printf("\n /tmp/max_move.MB.1 not open \n");
            fp_max_move=stdout;
          }

        fp_avg_move = fopen("/tmp/avg_move.MB.1","a");
        if (fp_avg_move == NULL)
          {
            printf("\n /tmp/avg_move.MB.1 not open \n");
            fp_avg_move=stdout;
          }
      }
  
    else
      OutFile=stdout;
    
    fprintf(OutFile,"\n-------------------------------------");
    fprintf(OutFile,"\n BP_Dim %i %i ",BP_DIM1,BP_DIM2);
    fprintf(OutFile,"\n me %i ",me);
    fprintf(OutFile,"\n numproc %i ",NumNodePgme(my_pgme));
    fprintf(OutFile,"\n numproc_other %i ",NumNodePgme(other_pgme));

    fprintf(OutFile,"\n Niter   ",IterationCounter);
    fprintf(OutFile,"\n Timers ");
    

    min1=return_timer_min(1) ;
    my1=return_timer(1) ;
    max1=return_timer_max(1) ;
    avg1=return_timer_avg(1) ;

    min2=return_timer_min(2) ;
    my2=return_timer(2) ;
    max2=return_timer_max(2) ;
    avg2=return_timer_avg(2) ;
     
    fprintf(OutFile,"\n                           =      min     mine      max      avg",            min1,my1,max1,avg1 );

    fprintf(OutFile,"\n Compute Sched MB -> Chaos = %8i %8i %8i %8i",
            min1,my1,max1,avg1);
    fprintf(OutFile,"\n remap                  = %8i %8i %8i %8i",
            min2,my2,max2,avg2);

    fprintf(OutFile,"\n-------------------------------------");

    if(me ==0)
      {
	fprintf(fp_max_scheds,"\n%d",max1);
	fprintf(fp_max_move,"\n%d",max2);
	
	fprintf(fp_avg_scheds,"\n%d",avg1);
	fprintf(fp_avg_move,"\n%d",avg2);
      }

    fclose(OutFile);

    if(me == 0)
      {
	fclose(fp_max_scheds);
	fclose(fp_avg_scheds);
	fclose(fp_max_move);
	fclose(fp_avg_move);
      }

  }
  Sync2Pgme(my_pgme,other_pgme);

  if(me==0) pvm_exit();
  
  printf("\n Finished normally in main1(MB)(me = %d)\n",me); 
  
}











