#include <stdio.h>
#include <pvm3.h>

#define NUM_NODES 16

/*
 * Note. I make children processes(Id is not 0) sleep for two seconds
 *       to make the process 0 take the first processor(eg. rogue11 or 31).
 *       (to guarantee that the process 0 outputs in the scratch1. 
 */

int start_master_slave(char **arg) {
  int numNode, i;
  int tids[100];
  int erm;
  int parent;
  
  if (pvm_parent() < 0) {
    fprintf(stderr,"Spawning %s on %s hosts\n", arg[0], arg[1]);
    sscanf(arg[1], "%i", &numNode);
    if (numNode == 1) 
      return numNode; 
    erm = pvm_spawn(arg[0], arg+1, PvmTaskDefault, NULL, numNode-1, tids);
    printf("Started %i task(s), total task(s) %i\n", erm, numNode);
    if (erm < numNode-1) {
      pvm_perror("spawn\n");
      for (i = 0; i < numNode-1; i++)
	if (tids[i] > 0) 
	  pvm_kill(tids[i]);	
      pvm_exit();
      return 0;
    } 
    else {
      pvm_initsend(PvmDataDefault);
      pvm_pkint(&numNode, 1, 1);
      if (erm = pvm_mcast(tids, numNode-1, 001) < 0)
	pvm_perror("error in first mcast\n");
      printf(" Started %i task\n", erm); 
    }
  }
  else {
    parent = pvm_parent();
    pvm_recv(parent, 001);
    pvm_upkint(&numNode, 1, 1);
    sleep(2);
  }
  
  return numNode;
}

int start_master_slave1(char **arg) {
  int numNode, i, j;

  char rogue[][8] = { 
    "rogue12",
    "rogue13",
    "rogue14",
    "rogue15",
    "rogue16",
    "rogue17",
    "rogue18",
    "rogue19",
    "rogue20",
    "rogue21",
    "rogue22",
    "rogue23",
    "rogue24",
    "rogue25",
    "rogue26",
    "rogue27",
    "rogue28",
    "rogue29",
    /*"rogue30",*/
    "rogue10",
    "rogue09",
    "rogue08",
    "rogue07",
    "rogue06"
  };

  int tids[100];
  int erm;
  int parent;
  
  printf("Start 1\n");
  if (pvm_parent() < 0) {
    /* no parent */
    sscanf(arg[1], "%i", &numNode);
    if (numNode == 1) 
      return numNode; 
    fprintf(stderr, "spawning...\n");
    for (i = 0; i < numNode - 1; i++) {
      erm = pvm_spawn(arg[0], arg+1, PvmTaskHost, rogue[i], 1, &tids[i]);      
      if (erm != 1) {
	pvm_perror("error in spawn\n");
	for (j = 0; i < numNode - 1; j++)
	  if (tids[j] > 0) 
	    pvm_kill(tids[j]);	
	pvm_exit();
	exit();
      }
    }
    printf("\nStarted %i task, total task %i, name=%s \n", erm, numNode, arg[0]);
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&numNode, 1, 1);
    if (erm = pvm_mcast(tids, numNode - 1, 001) < 0)
      pvm_perror("error in first mcast\n");
    printf(" Started %i task\n", erm); 
  }
  else {
    parent = pvm_parent();
    pvm_recv(parent, 001);
    pvm_upkint(&numNode, 1, 1);
    sleep(2);
  }
  return numNode;
}

int start_master_slave2(char **arg) {
  int numNode, i, j;
  
  char rogue[][8] = { 
    /*"rogue32",*/
    "rogue33",
    "rogue34",
    /*"rogue35",*/
    "rogue36",
    /*"rogue37",*/
    "rogue38",
    "rogue39",
    /*"rogue40",*/
    "rogue41",
    "rogue42",
    "rogue43",
    "rogue44",
    "rogue45",
    /*"rogue46",*/
    "rogue47",
    "rogue48",
    "rogue49",
    /*"rogue50",*/
    "rogue01",
    "rogue02",
    "rogue03",
    "rogue04",
    "rogue05"
  };

  int tids[100];
  int erm;
  int parent;

  printf("Start 1\n");  
  if (pvm_parent() < 0) {
    /* no parent */
    sscanf(arg[1], "%i", &numNode);
    if (numNode == 1)
      return numNode; 
    fprintf(stderr, "spawning...\n");
    for(i = 0; i < numNode - 1; i++) {
      erm = pvm_spawn(arg[0], arg+1, PvmTaskHost, rogue[i], 1, &tids[i]);
      if (erm != 1) {
	pvm_perror("error in spawn\n");
	for (j = 0; i < numNode - 1; j++)
	  if (tids[j] > 0) 
	    pvm_kill(tids[j]);	
	pvm_exit();
	exit();
      }
    }
    printf("\nStarted %i task, total task %i, name=%s \n", erm, numNode, arg[0]);
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&numNode,1,1);
    if (erm = pvm_mcast(tids,numNode - 1,001)<0)
      pvm_perror("error in first mcast\n");
    printf(" Started %i task\n", erm); 
  }
  else {
    parent = pvm_parent();
    pvm_recv(parent,001);
    pvm_upkint(&numNode,1,1);
    sleep(2);
  }
  return numNode;
}

int start_master_slave1_red(char **arg) {
  int numNode, i, j;

 char rogue[][10] = { 
   "red02",
   "red03",
   "red04",
   "red05",
   "red06",
   "red07",
   "red08",
   "red09",
   "red10",
   "red11",
   "red12",
   "red13",
   "red14",
   "red15",
   "red16"
 };

 int tids[100];
 int erm;
 int parent;

 printf("Start 1\n");
 if (pvm_parent() < 0) {
   /* no parent */
   sscanf(arg[1],"%i",&numNode);
   if (numNode == 1) 
     return numNode; 
   fprintf(stderr,"spawn, no sp2\n");
   for(i = 0; i < numNode-1; i++) {
     erm = pvm_spawn(arg[0], arg+1, PvmTaskHost, rogue[i], 1, &tids[i]);
     if (erm != 1) {
       pvm_perror("error in spawn \n");
       for (j = 0; i < numNode-1; j++)
	 if (tids[j] > 0) 
	   pvm_kill(tids[j]);	
       pvm_exit();
       exit();
     }
   }
   printf("\nStarted %i task, total task %i, name=%s \n", erm, numNode, arg[0]);
   pvm_initsend(PvmDataDefault);
   pvm_pkint(&numNode, 1, 1);
   if (erm = pvm_mcast(tids, numNode-1, 001) < 0)
     pvm_perror("error in first mcast\n");
   printf(" Started %i task\n", erm); 
 }
 else {
   parent = pvm_parent();
   pvm_recv(parent, 001);
   pvm_upkint(&numNode, 1, 1);
   sleep(2);
 }
 return numNode;
}
