#include "pvm_utils.h"
#include <stdio.h>
#include <unistd.h>
#include <pvm3.h>

int pvm_startup(char* argv[], int requested) {
  int i;
  int parent;
  int started;
  int tids[64];
  
  if (requested < 2)
    return requested;
  
  parent = pvm_parent();
  if (parent < 0) {
    pvm_catchout(stdout);
    pvm_catchout(stderr);
    started = pvm_spawn(argv[0], argv+1, PvmTaskDefault, 0, requested-1, tids);
    if (started < requested-1) {
      pvm_perror("spawn");
      for (i = 0; i < requested-1; ++i) {
	if (tids[i] > 0) {
	  pvm_kill(tids[i]);
	}
      }
      pvm_exit();
      return started;
    } else {
      ++started;
    }
  } else {
    started = requested;
  }
  
  return started;  
}

int pvm_dupgroup(char* groupname, int r) {
  if (r == 0) {
    return pvm_joingroup(groupname);
  } else {
    while (pvm_gsize(groupname) != r)
      sleep(1);
    return pvm_joingroup(groupname);
  }
}

int pvm_allstatus(char* groupname, int status, int msgtag) {
  int allstatus;
  int i, mytid, gsize;

  mytid = pvm_mytid();
  gsize = pvm_gsize(groupname);

  pvm_initsend(PvmDataDefault);
  pvm_pkint(&status, 1, 1);
  pvm_bcast(groupname, msgtag);

  allstatus = status;
  for (i = 0; i < gsize; ++i) {
    if (mytid != pvm_gettid(groupname, i)) {
      pvm_recv(pvm_gettid(groupname, i), msgtag);
      pvm_upkint(&status, 1, 1);
      allstatus *= status;
    }
  }

  pvm_barrier(groupname, gsize);

  return allstatus;
}
