      subroutine pvmfstartup(taskname, requested, started)
      implicit none
      include 'fpvm3.h'

      character*10 taskname
      integer requested
      integer started
      
      integer i
      integer parent
      integer tids(64)
      integer info
      
      if (requested .LT. 2) then
         return
      end if
      
      call pvmfparent(parent)
      if (parent .LT. 0) then
         call pvmfcatchout(1, info)
         call pvmfspawn(taskname, PVMDEFAULT, '*', 
     $        requested-1, tids, started)
         if (started .LT. requested-1) then
            call pvmfperror('spawn', info)
            do i = 1, requested
               if (tids(i) .GT. 0) then
                  call pvmfkill(tids(i), info)
               end if
            end do
            call pvmfexit(info)
            return
         else
            started = started + 1
         end if
      else
         started = requested
      end if
      
      end

      subroutine pvmfallstatus(groupname, status, msgtag)
      implicit none
      include 'fpvm3.h'

      character*4 groupname
      integer status, msgtag

      integer allstatus
      integer i, mytid, gsize, tid, info

      call pvmfmytid(mytid)
      call pvmfgsize(groupname, gsize)

      call pvmfinitsend(PVMDEFAULT, info)
      call pvmfpack(INTEGER4, status, 1, 1, info)
      call pvmfbcast(groupname, msgtag, info)

      allstatus = status
      do i = 1, gsize
         call pvmfgettid(groupname, i-1, tid)
         if (mytid .NE. tid) then
            call pvmfrecv(tid, msgtag, info)
            call pvmfunpack(INTEGER4, status, 1, 1, info)
            allstatus = allstatus * status
         end if         
      end do

      call pvmfbarrier(groupname, gsize, info)
      status = allstatus
      end
      
