#include <stdio.h>
#include <mpi.h>

int main(int argc, char* argv[]) {
  int rank, size;

  MPI_Init(&argc, &argv);

  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  printf("In MPI, I am %d of %d\n", rank, size);

  pvm_joingroup(GROUP);
  pvm_barrier(GROUP, TASKS);
                                                                                            
  rank = pvm_getinst(GROUP, pvm_mytid());
  size = pvm_gsize(GROUP);
  printf("In PVM, I am %d of %d\n", rank, size);
  pvm_barrier(GROUP, TASKS);
                                                                                            
  pvm_exit();

  MPI_Finalize();
  return 0;
}
