#include <intercomm.h>
#include <stdio.h>

int main(int argc, char* argv[]) {
  IC_Program* green, *yellow, *red, *orange;

  green = IC_Init("green", 1, 0);
  yellow = IC_Wait("yellow", 1);
  red = IC_Wait("red", 1);
  orange = IC_Wait("orange", 1);

  if (IC_Sync(green, yellow) < 0)
    fprintf(stderr, "green could not sync with yellow\n");
  if (IC_Sync(green, red) < 0)
    fprintf(stderr, "green could not sync with red\n");
  if (IC_Sync(green, orange) < 0)
    fprintf(stderr, "green could not sync with orange\n");
  
  IC_Free_program(orange);
  IC_Free_program(red);
  IC_Free_program(yellow);

  IC_Quit(green);

  return 0;
}
