#include <intercomm.h>
#include <stdio.h>
#include <mpi.h>

int main(int argc, char* argv[]) {
  IC_Program* orange, *red, *green, *yellow;
  MPI_Comm comm;

  MPI_Init(&argc, &argv);
  MPI_Comm_split(MPI_COMM_WORLD, COLOR, 0, &comm);

  orange = IC_Init("orange", 1, 0);
  red = IC_Wait("red", 1);
  green = IC_Wait("green", 1);
  yellow = IC_Wait("yellow", 1);

  if (IC_Sync(orange, red) < 0)
    fprintf(stderr, "orange could not sync with red\n");
  if (IC_Sync(orange, yellow) < 0)
    fprintf(stderr, "orange could not sync with yellow\n");
  if (IC_Sync(orange, green) < 0)
    fprintf(stderr, "orange could not sync with green\n");
  
  IC_Free_program(green);
  IC_Free_program(yellow);
  IC_Free_program(red);

  IC_Quit(orange);
  
  MPI_Comm_free(&comm);
  MPI_Finalize();

  return 0;
}
