#include <intercomm.h>
#include <stdio.h>

int main(int argc, char* argv[]) {
  IC_Program* yellow, *green, *red, *orange;

  yellow = IC_Init("yellow", 1, 0);
  green = IC_Wait("green", 1);
  orange = IC_Wait("orange", 1);
  red = IC_Wait("red", 1);

  if (IC_Sync(yellow, green) < 0)
    fprintf(stderr, "yellow could not sync with green\n");
  if (IC_Sync(yellow, orange) < 0)
    fprintf(stderr, "yellow could not sync with orange\n");
  if (IC_Sync(yellow, red) < 0)
    fprintf(stderr, "yellow could not sync with red\n");
  
  IC_Free_program(red);
  IC_Free_program(orange);
  IC_Free_program(green);

  IC_Quit(yellow);

  return 0;
}
