#!/usr/bin/env perl 
# written by Henrique Andrade (hcma@cs.umd.edu) - June 7, 2003
# creates a host file for PVM based on information collected from executions
# of alloc_host.pl and the multi-application configuration (i.e., given in
# the command line)
# this script is invoked by POE job submission scripts

my (@hosts,$hostfile);

sub addHost {
# making sure we are not adding repeated hosts
  my ($host)=@_;
  foreach(@hosts) {
    return if ($host eq $_);
  }
  print "adding new host [$host]\n";
  push @hosts,$host;
}

sub run {
# making sure we are not adding repeated hosts
  my ($cmdline)=@_;
  print "executing: $cmdline\n";
  `$cmdline` unless ($debug);
}

# setting the hostfile name
  die "this program must be run by one processor only, currently MP_PROCS=",$ENV{"MP_PROCS"},"!\n" unless $ENV{MP_PROCS}==1;
  die "usage: $0 <application-name>\n" unless (scalar(@ARGV)==1);
  $home=$ENV{'HOME'};
  $hostfile="$home/hostfile.WE.temp";
  $hostfiletemp="$home/hostfile.".$$.".WE";
# deleting a pre-existing host file
  unlink $hostfile;
  unlink $hostfiletemp;
  unlink </tmp/pvmd.*>;
# reading multi-application run configuration
  $applications{"vis"}->{NPROCESS}=1;
  open CONFFILE,"<$ARGV[0]" || die "couldn't open file '$ARGV[0]'\n";
  while(<CONFFILE>) {
    next if (/^#/);
    chop;
    ($conf,$n)=split("=");
    $applications{"waveeq-left"}->{NPROCESS}=$n if ($conf=~/LeftN/);
    $applications{"waveeq-right"}->{NPROCESS}=$n if ($conf=~/RightN/);
  }
  close CONFFILE;
  foreach (keys %applications) {
    print $applications{$_}->{NPROCESS}," $_ processes to run\n";
    $totalprocess+=$applications{$_}->{NPROCESS};
  }
  print "A total of $totalprocess process(es) will run\n";
# wait for all processes of all applications to start
  while(1) {
    opendir CURRENT, "$home" || die "problems opening current dir!\n";
    my (@allfiles)=readdir CURRENT;
    foreach $filename (@allfiles) {
#      print "processing file [$filename]...\n";
      foreach $application (keys %applications) {
#        print "looking for [$application]...\n";
        if ($filename=~/$application/ && $filename=~/#/) {
          $applications{$application}->{NPROCESS}--;
          ($app,$host,$pid)=split("#",$filename);
#          print "$app $host $pid\n";
          addHost($host);
          $currentnprocess++;
          unlink "$home/$filename";
          die "Too many $application instances started. Invalid configuration in waveeq.conf! Aborting!\n" if $applications{$application}->{NPROCESS}<0;
          print "another instance of $application has started (",$applications{$application}->{NPROCESS}," other copies will start)...\n";
        }
      }
    }
    closedir CURRENT;
    last if ($currentnprocess>=$totalprocess);
    sleep 2;
    print $totalprocess-$currentnprocess," processes still need to start. Waiting...\n";
  }
  die "there were left over files in ",$ENV{'HOME'}," aborting!\n" if ($currentnprocess>$totalprocess);
  run("rm -f $home/.ssh/known_hosts.bak");
  run("mv $home/.ssh/known_hosts $home/.ssh/known_hosts.bak");
  run("touch $home/.ssh/known_hosts");
  open HOSTFILE,">$hostfiletemp" || die "couldn't open '$hostfiletemp'\n";
  foreach(@hosts) {
    print HOSTFILE "add $_\n";
    run("ssh-keyscan -t rsa,dsa $_ >> $home/.ssh/known_hosts");
    run("ssh $_ 'hostname; rm -f /tmp/pvm* > /dev/null; echo halt | pvm'");
  }
  close HOSTFILE;
  run("mv $hostfiletemp $hostfile");
  run("cat $home/hostfile.WE.temp | pvm > /dev/null");
    run("rm -f $home/.ssh/known_hosts");
# restoring ssh configuration
  run("mv $home/.ssh/known_hosts.bak $home/.ssh/known_hosts");
  print "---> PVM started\n";
  run("mv $home/hostfile.WE.temp $home/hostfile.WE > /dev/null");
