#!/bin/sh
#@ job_type         = serial
#@ output           = vis.llout
#@ error            = $(output)
#@ class            = cdev
#@ resources        = ConsumableCpus(1) ConsumableMemory(16 MB)
#@ wall_clock_limit = 0:10
#@ notification     = always
#@ queue

echo "Running on ------->" `hostname`
echo "Cleaning up to ensure a clean start: shutting PVM down and removing /tmp/pvm* files"
echo halt | pvm > /dev/null
rm /tmp/pvm* 2> /dev/null
get_allcd_hosts.pl vis
echo "Creating hostfile and setting up the PVM virtual machine"
create_pvm_hostfile.pl waveeq.conf
if [ "$?" -ne "0" ]; then
  echo "Sorry, couldn't create hostfile! Please kill the other POE jobs manually.."
  rm ~/*.WE 2> /dev/null
  exit 1
fi
vis
echo "Shutting down the PVM virtual machine"
echo halt | pvm > /dev/null
rm ~/*.WE 2> /dev/null
echo "Multi-application run has terminated!"
