      program fexample
      implicit none
      include 'mpif.h'

      character*8 localname
      data localname / 'cexample' /
      character*8 othername
      data othername / 'fexample' /
      integer local_tasks
      data local_tasks / 4 /
      integer other_tasks
      data other_tasks / 8 /
      integer i, rank

      integer groupcomm
      
      integer local
      integer other

      integer desc
      real A(200)
      
      integer region_set(2)
      integer indices(8)
      integer sched
      integer tag
      data tag / 99 /

      integer sts

c     initialize mpi
      print *, 'initialize mpi'
      call MPI_INIT(sts)
      call MPI_COMM_DUP(MPI_COMM_WORLD, groupcomm, sts)
      call MPI_COMM_RANK(groupcomm, rank, sts)
      call MPI_BARRIER(groupcomm, sts)

c     initialize ic
      print *, 'initialize ic'
      call IC_Init(localname, local_tasks, rank, local)    
      call IC_Wait(othername, other_tasks, other)
      call IC_Sync(local, other, sts)

c     create a block decomposition type array descriptor and array
      call create_ttable(local_tasks, rank, A, desc)

c     define two 8 element regions for transfer
      print *, 'define regions'
      do i = 1, 8
         indices(i) = i
      end do
      call IC_Create_enum_region(indices, 8, region_set(1))    
      do i = 1, 8
         indices(i) = i + 400
      end do
      call IC_Create_enum_region(indices, 8, region_set(2))
      
      print *, 'create schedule'
      call IC_Compute_schedule(local, other, desc, region_set,
     $     2, sched)
      print *, 'send data'
      call IC_Send_float(other, sched, A, tag, sts)     
      call IC_Sync(local, other, sts)
      call IC_Free_sched(sched)
      
c     cleanup
      print *, 'clean up'
      call IC_Free_region(region_set(2))
      call IC_Free_region(region_set(1))

      call IC_Free_desc(desc)

      call IC_Free_program(other)      
      call IC_Quit(local, sts)
      
      call MPI_BARRIER(groupcomm, sts)
      call MPI_COMM_FREE(groupcomm)
      call MPI_FINALIZE(sts)

      end

      subroutine create_ttable(p, r, A, desc)
      implicit none
      integer p, r
      real A(200)
      integer desc

      integer globals(200), offsets(200), tasks(200)
      integer i

      do i = 1, 200
         globals(i) = 200*r + i
      end do
      
      do i = 1, 200
         offsets(i) = (i-1)/p + 50*r + 1
         tasks(i) = mod((i-1), p)
      end do
      
      call IC_Create_ttable_desc(globals, offsets, tasks, 200, desc)

      do i = 1, 200
         A(i) = globals(i)
      end do

      end
