/*
 * File: mbp2bdecomp.h
 * Auth: Jae-Yong Lee (jylee@cs.umd.edu)
 *       Christian Hansen (chansen@cs.umd.edu)
 *       University of Maryland, College Park
 * Desc: 
 * Date: 
 */

#include "mbp2bdecomp.h"
#include "hash.h"
#include <stdlib.h>

#define IC_TRANSLATE_PARTI_DESCRIPTOR_F77 F77_FUNC_(ic_translate_parti_descriptor, IC_TRANSLATE_PARTI_DESCRIPTOR)

#if MBP_VERSION > 1

void convert_tree(Decomp_TREE* n1, decomp_tree_t* n2, int ndims) {
  int i;

  n1->nDims = ndims;
  n1->num_of_partitions = n2->partitions;
  if (n1->num_of_partitions > 0) {
    n1->children = (Decomp_TREE*)malloc(n1->num_of_partitions*sizeof(Decomp_TREE));
    n1->keys = (int*)malloc((n1->num_of_partitions-1)*sizeof(int));
    n1->block_info = 0;
    for (i = 0; i < n1->num_of_partitions; ++i) {
      convert_tree(&(n1->children[i]), &(n2->children[i]), ndims);
    }
  } else {
    n1->children = 0;
    n1->keys = 0;
    n1->block_info = Allocate_Block(n2->leaf->rank);
    n1->block_info->proc = n2->leaf->task;
    i = sizeof(int)*n1->block_info->nDims;
    memcpy(n1->block_info->size, n2->leaf->size, i);
    memcpy(n1->block_info->start_global, n2->leaf->globalLowerBound, i);
    memcpy(n1->block_info->end_global, n2->leaf->globalUpperBound, i);
    memcpy(n1->block_info->coord, n2->leaf->coord, i);
  }
}

IC_Desc* IC_Translate_parti_descriptor(DARRAY* darray) {
  IC_Desc* desc;
  decomp_Birreg* decomp;

  desc = (IC_Desc*)malloc(sizeof(IC_Desc));
  desc->type = IC_BDECOMP;
  
  decomp = Allocate_decomp_Birreg(darray->decomp->rank);
  decomp->col_majeur = 0;
  convert_tree(decomp->root, &(darray->decomp->root), darray->decomp->rank);
  
  desc->spec = (void*)decomp;
  return desc;
}

#else

void build_tree(Decomp_TREE* decomp_node, DARRAY* dad, int which_dim, int my_order,
		int* sizes, int* global_start, int* global_end,	int* coord) {
  int i,j;
  int* size_new;
  int* global_start_new;
  int* global_end_new;
  int* coord_new;
  int tmp;
  int own;
  
  decomp_node->nDims = dad->decomp->nDims; 
  
  if (which_dim == dad->decomp->nDims) { /* leaf node */
    
    decomp_node->num_of_partitions = 0;
    decomp_node->keys = 0;
    decomp_node->children = 0;
    
    /* block info in leaf nodes*/
    
    decomp_node->block_info = Allocate_Block(decomp_node->nDims);
    
    for(i =0; i < decomp_node->nDims; i++) {
      decomp_node->block_info->size[i] = sizes[i];
      decomp_node->block_info->start_global[i] = global_start[i];
      decomp_node->block_info->end_global[i] = global_end[i];	
      decomp_node->block_info->coord[i] = coord[i];
    }
    
    /* calculate ownership of this leaf node(block) using cood and gray fucntion */
    
    tmp = 1;
    own = dad->decomp->baseProc;
    
    for (i = 1; i < dad->decomp->nDims; i++)
      tmp *= dad->decomp->dimProc[i];

    for (i = 0; i < dad->decomp->nDims - 1; i++) {
      own += coord[i]* tmp ;
      tmp /= dad->decomp->dimProc[i + 1];
    }
    
    own += coord[i];    
    decomp_node->block_info->proc = own;
    
  } else {   /* nonleaf node */ 
    decomp_node->num_of_partitions = dad->decomp->dimProc[which_dim];    
    decomp_node->keys = (int*)malloc((decomp_node->num_of_partitions-1)*sizeof(int));
    /* put key info */ 
    /* I don't need this because i need just leaf info */
    decomp_node->children = (Decomp_TREE*)malloc(decomp_node->num_of_partitions*sizeof(Decomp_TREE));
    decomp_node->block_info = NULL; /* nonleaf node */ 
    
    for (i = 0; i < decomp_node->num_of_partitions; i++) {
      /* size */
      size_new = (int*)malloc((which_dim+1)*sizeof(int));
      
      for (j = 0; j < which_dim; j++)
	size_new[j] = sizes[j];
      
      if (i == 0) {
	size_new[which_dim] = dad->dimVecL_L[which_dim];
      } else if (i == decomp_node->num_of_partitions-1) {
	size_new[which_dim] = dad->dimVecL_R[which_dim];
      } else { 
	size_new[which_dim] = dad->dimVecL[which_dim];
      }

      /* global start */
      global_start_new = (int*)malloc((which_dim+1)*sizeof(int));
      
      for (j = 0; j < which_dim; j++)
	global_start_new[j] = global_start[j];
      
      if (i == 0)
	global_start_new[which_dim] = 0;      
      else    
	global_start_new[which_dim] =dad->dimVecL_L[which_dim]+(i -1)*(dad->dimVecL[which_dim]) ;
      
      /* global end */
      global_end_new = (int*)malloc((which_dim+1)*sizeof(int));
      
      for (j = 0; j < which_dim; j++)
	global_end_new[j] = global_end[j];
      
      if(i == (dad->decomp->dimProc[which_dim]-1)) {
	global_end_new[which_dim] = dad->dimVecG[which_dim] - 1;      
      } else if (i == (dad->decomp->dimProc[which_dim]-2)) {
	global_end_new[which_dim] = dad->dimVecG[which_dim] - 1 - dad->dimVecL_R[which_dim];
      } else {
	global_end_new[which_dim] = dad->dimVecG[which_dim] - 1 - dad->dimVecL_R[which_dim] 
	  - ((dad->decomp->dimProc[which_dim]-2)-i)*dad->dimVecL[which_dim];
      }
      
      /* coordinate */
      coord_new = (int*)malloc((which_dim+1)*sizeof(int));
      for (j = 0; j < which_dim; j++)
	coord_new[j] = coord[j];
      
      coord_new[which_dim] = i;
      
      build_tree(&(decomp_node->children[i]), dad, which_dim+1, i, size_new,
		 global_start_new, global_end_new, coord_new);
      
    }
  }

  if (which_dim > 0) {
    free(sizes);
    free(global_start);
    free(global_end);
    free(coord);
  }
}

decomp_Birreg* DARRAY2BirregTree(DARRAY* dad) {
  int i,j;
  decomp_Birreg* decomp_irr;
  
  decomp_irr = Allocate_decomp_Birreg(dad->decomp->nDims);
  decomp_irr->col_majeur = 0;
  build_tree(decomp_irr->root, dad, 0, 0, 0, 0, 0, 0);
  
  return decomp_irr;
}

IC_Desc* IC_Translate_parti_descriptor(DARRAY* darray) {
  IC_Desc* desc;
  
  desc = (IC_Desc*)malloc(sizeof(IC_Desc));
  desc->type = IC_BDECOMP;
  desc->spec = DARRAY2BirregTree(darray);
  
  return desc;
}

#endif

/*
  void IC_TRANSLATE_PARTI_DESCIPTOR_F77(int* i, int* d) {
  DARRAY* darray;
  IC_Desc* desc;
  
  darray = lookupda(*i);
  desc = IC_Translate_parti_descriptor(darray);
  *d = pinsert((void*)desc);
  }
*/
