
#include <iostream>
#include <string.h>
#include "IC_EndPoint.h"
#include "c-wrapper.h"
#include "carray_descriptor.h"


#define IC_EXPORT_ARRAY_INT_HELPER_F77     F77_FUNC_(ic_export_array_int_helper, IC_EXPORT_ARRAY_INT_HELPER)
#define IC_IMPORT_ARRAY_INT_HELPER_F77     F77_FUNC_(ic_import_array_int_helper, IC_IMPORT_ARRAY_INT_HELPER)
#define IC_DUMP_INT_ARRAY_INTERNALS_F77 F77_FUNC_(ic_dump_int_arrayinternals, IC_DUMP_INT_ARRAY_INTERNALS)

#define IC_DUMP_INT_ARRAY_INFO_F77      F77_FUNC_(ic_dump_int_array_info, IC_DUMP_INT_ARRAY_INFO)



#define IC_EXPORT_ARRAY_FLOAT_HELPER_F77     F77_FUNC_(ic_export_array_float_helper, IC_EXPORT_ARRAY_FLOAT_HELPER)
#define IC_IMPORT_ARRAY_FLOAT_HELPER_F77     F77_FUNC_(ic_import_array_float_helper, IC_IMPORT_ARRAY_FLOAT_HELPER)
#define IC_DUMP_FLOAT_ARRAY_INTERNALS_F77 F77_FUNC_(ic_dump_float_arrayinternals, IC_DUMP_FLOAT_ARRAY_INTERNALS)

#define IC_DUMP_FLOAT_ARRAY_INFO_F77      F77_FUNC_(ic_dump_float_array_info, IC_DUMP_FLOAT_ARRAY_INFO)



#define IC_EXPORT_ARRAY_DOUBLE_HELPER_F77     F77_FUNC_(ic_export_array_double_helper, IC_EXPORT_ARRAY_DOUBLE_HELPER)
#define IC_IMPORT_ARRAY_DOUBLE_HELPER_F77     F77_FUNC_(ic_import_array_double_helper, IC_IMPORT_ARRAY_DOUBLE_HELPER)
#define IC_DUMP_DOUBLE_ARRAY_INTERNALS_F77 F77_FUNC_(ic_dump_double_arrayinternals, IC_DUMP_DOUBLE_ARRAY_INTERNALS)

#define IC_DUMP_DOUBLE_ARRAY_INFO_F77      F77_FUNC_(ic_dump_double_array_info, IC_DUMP_DOUBLE_ARRAY_INFO)




#define IC_SEND_CHAR_HELPER_F77     F77_FUNC_(ic_send_char_helper, IC_SEND_CHAR_HELPER)
#define IC_RECV_CHAR_HELPER_F77     F77_FUNC_(ic_recv_char_helper, IC_RECV_CHAR_HELPER)



#define IC_SEND_SHORT_HELPER_F77     F77_FUNC_(ic_send_short_helper, IC_SEND_SHORT_HELPER)
#define IC_RECV_SHORT_HELPER_F77     F77_FUNC_(ic_recv_short_helper, IC_RECV_SHORT_HELPER)



#define IC_SEND_INT_HELPER_F77     F77_FUNC_(ic_send_int_helper, IC_SEND_INT_HELPER)
#define IC_RECV_INT_HELPER_F77     F77_FUNC_(ic_recv_int_helper, IC_RECV_INT_HELPER)



#define IC_SEND_FLOAT_HELPER_F77     F77_FUNC_(ic_send_float_helper, IC_SEND_FLOAT_HELPER)
#define IC_RECV_FLOAT_HELPER_F77     F77_FUNC_(ic_recv_float_helper, IC_RECV_FLOAT_HELPER)



#define IC_SEND_DOUBLE_HELPER_F77     F77_FUNC_(ic_send_double_helper, IC_SEND_DOUBLE_HELPER)
#define IC_RECV_DOUBLE_HELPER_F77     F77_FUNC_(ic_recv_double_helper, IC_RECV_DOUBLE_HELPER)



extern "C" {
  
void IC_EXPORT_ARRAY_INT_HELPER_F77(IC_EndPoint** o, const F90_intArray** A, int* status) {
#ifdef DEBUG
  cout << "Info about the array being exported:\n";
  IC_DUMP_INT_ARRAY_INTERNALS_F77(A);
  cout << "exporting: Array contents:\n";
  PRINTINTARRAY_F77(A);
#endif
 (*o)->exportArray(**A,*status);
}

  
void IC_IMPORT_ARRAY_INT_HELPER_F77(IC_EndPoint** o, const F90_intArray** A, int* status) {
#ifdef DEBUG
  cout << "Info about the array being imported:\n";
  IC_DUMP_INT_ARRAY_INTERNALS_F77(A);
  cout << "importing: Current array contents:\n";
  PRINTINTARRAY_F77(A);
#endif
  (*o)->importArray(**A,*status);
}

  
void IC_DUMP_INT_ARRAY_INTERNALS_F77(const F90_intArray** A) {
  unsigned i;
  printf("rank %d\n",(*A)->rank);
  for (i=0;i<static_cast<unsigned>((*A)->rank);++i)
    printf("shape [%d] %d stride [%d] %d\n",i,(*A)->shape[i],i,(*A)->stride[i]);
}

  
void IC_EXPORT_ARRAY_FLOAT_HELPER_F77(IC_EndPoint** o, const F90_floatArray** A, int* status) {
#ifdef DEBUG
  cout << "Info about the array being exported:\n";
  IC_DUMP_FLOAT_ARRAY_INTERNALS_F77(A);
  cout << "exporting: Array contents:\n";
  PRINTFLOATARRAY_F77(A);
#endif
 (*o)->exportArray(**A,*status);
}

  
void IC_IMPORT_ARRAY_FLOAT_HELPER_F77(IC_EndPoint** o, const F90_floatArray** A, int* status) {
#ifdef DEBUG
  cout << "Info about the array being imported:\n";
  IC_DUMP_FLOAT_ARRAY_INTERNALS_F77(A);
  cout << "importing: Current array contents:\n";
  PRINTFLOATARRAY_F77(A);
#endif
  (*o)->importArray(**A,*status);
}

  
void IC_DUMP_FLOAT_ARRAY_INTERNALS_F77(const F90_floatArray** A) {
  unsigned i;
  printf("rank %d\n",(*A)->rank);
  for (i=0;i<static_cast<unsigned>((*A)->rank);++i)
    printf("shape [%d] %d stride [%d] %d\n",i,(*A)->shape[i],i,(*A)->stride[i]);
}

  
void IC_EXPORT_ARRAY_DOUBLE_HELPER_F77(IC_EndPoint** o, const F90_doubleArray** A, int* status) {
#ifdef DEBUG
  cout << "Info about the array being exported:\n";
  IC_DUMP_DOUBLE_ARRAY_INTERNALS_F77(A);
  cout << "exporting: Array contents:\n";
  PRINTDOUBLEARRAY_F77(A);
#endif
 (*o)->exportArray(**A,*status);
}

  
void IC_IMPORT_ARRAY_DOUBLE_HELPER_F77(IC_EndPoint** o, const F90_doubleArray** A, int* status) {
#ifdef DEBUG
  cout << "Info about the array being imported:\n";
  IC_DUMP_DOUBLE_ARRAY_INTERNALS_F77(A);
  cout << "importing: Current array contents:\n";
  PRINTDOUBLEARRAY_F77(A);
#endif
  (*o)->importArray(**A,*status);
}

  
void IC_DUMP_DOUBLE_ARRAY_INTERNALS_F77(const F90_doubleArray** A) {
  unsigned i;
  printf("rank %d\n",(*A)->rank);
  for (i=0;i<static_cast<unsigned>((*A)->rank);++i)
    printf("shape [%d] %d stride [%d] %d\n",i,(*A)->shape[i],i,(*A)->stride[i]);
}


  
void IC_SEND_CHAR_HELPER_F77(int* p, int* s, const F90_charArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Send_char(otherp, sched, (*A)->base, *tag);
}

  
void IC_RECV_CHAR_HELPER_F77(int* p, int* s, const F90_charArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Recv_char(otherp, sched, (*A)->base, *tag);
}

  
void IC_SEND_SHORT_HELPER_F77(int* p, int* s, const F90_shortArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Send_short(otherp, sched, (*A)->base, *tag);
}

  
void IC_RECV_SHORT_HELPER_F77(int* p, int* s, const F90_shortArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Recv_short(otherp, sched, (*A)->base, *tag);
}

  
void IC_SEND_INT_HELPER_F77(int* p, int* s, const F90_intArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Send_int(otherp, sched, (*A)->base, *tag);
}

  
void IC_RECV_INT_HELPER_F77(int* p, int* s, const F90_intArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Recv_int(otherp, sched, (*A)->base, *tag);
}

  
void IC_SEND_FLOAT_HELPER_F77(int* p, int* s, const F90_floatArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Send_float(otherp, sched, (*A)->base, *tag);
}

  
void IC_RECV_FLOAT_HELPER_F77(int* p, int* s, const F90_floatArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Recv_float(otherp, sched, (*A)->base, *tag);
}

  
void IC_SEND_DOUBLE_HELPER_F77(int* p, int* s, const F90_doubleArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Send_double(otherp, sched, (*A)->base, *tag);
}

  
void IC_RECV_DOUBLE_HELPER_F77(int* p, int* s, const F90_doubleArray** A, int* tag, int* sts) {
  IC_Program* otherp;
  IC_Sched* sched;

  otherp = (IC_Program*)plookup(*p);
  sched = (IC_Sched*)plookup(*s);

  *sts = IC_Recv_double(otherp, sched, (*A)->base, *tag);
}

}
