

#include "move.h"
#include "global.h"
#include "error.h"
#include "intercomm.h"
#include <stdlib.h>
#include <stdio.h>
#include <pvm3.h>






int IC_Send_char(IC_Program* to, IC_Sched* sched, char* data, int tag) {
  int proc;
  OneSched_s *Osched; 
  int sendFlag;

  setcall("IC_Send_char");
  if (to == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }
  
  for (proc = 0; proc < sched->nproc; proc++) { 
    sendFlag = 0;
    Osched = sched->sched[proc];
    
    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkbyte(data+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     
    
    if (sendFlag == 1) {
      pvm_send(TidPgme((pgme_s*)to,proc), tag);
    }
  }
  
  return 0;
}


int IC_Send_short(IC_Program* to, IC_Sched* sched, short* data, int tag) {
  int proc;
  OneSched_s *Osched; 
  int sendFlag;

  setcall("IC_Send_short");
  if (to == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }
  
  for (proc = 0; proc < sched->nproc; proc++) { 
    sendFlag = 0;
    Osched = sched->sched[proc];
    
    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkshort(data+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     
    
    if (sendFlag == 1) {
      pvm_send(TidPgme((pgme_s*)to,proc), tag);
    }
  }
  
  return 0;
}


int IC_Send_int(IC_Program* to, IC_Sched* sched, int* data, int tag) {
  int proc;
  OneSched_s *Osched; 
  int sendFlag;

  setcall("IC_Send_int");
  if (to == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }
  
  for (proc = 0; proc < sched->nproc; proc++) { 
    sendFlag = 0;
    Osched = sched->sched[proc];
    
    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkint(data+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     
    
    if (sendFlag == 1) {
      pvm_send(TidPgme((pgme_s*)to,proc), tag);
    }
  }
  
  return 0;
}


int IC_Send_float(IC_Program* to, IC_Sched* sched, float* data, int tag) {
  int proc;
  OneSched_s *Osched; 
  int sendFlag;

  setcall("IC_Send_float");
  if (to == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }
  
  for (proc = 0; proc < sched->nproc; proc++) { 
    sendFlag = 0;
    Osched = sched->sched[proc];
    
    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkfloat(data+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     
    
    if (sendFlag == 1) {
      pvm_send(TidPgme((pgme_s*)to,proc), tag);
    }
  }
  
  return 0;
}


int IC_Send_double(IC_Program* to, IC_Sched* sched, double* data, int tag) {
  int proc;
  OneSched_s *Osched; 
  int sendFlag;

  setcall("IC_Send_double");
  if (to == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }
  
  for (proc = 0; proc < sched->nproc; proc++) { 
    sendFlag = 0;
    Osched = sched->sched[proc];
    
    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkdouble(data+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     
    
    if (sendFlag == 1) {
      pvm_send(TidPgme((pgme_s*)to,proc), tag);
    }
  }
  
  return 0;
}


int IC_Recv_char(IC_Program* from, IC_Sched* sched, char* data, int tag) {
  int proc;
  OneSched_s *Osched;
  
  setcall("IC_Recv_char");
  if (from == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }

  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme((pgme_s*)from,proc), tag);
      while (Osched != NULL) {
	pvm_upkbyte(data+Osched->offset, Osched->size, 1); 
	Osched = Osched->next;	    
      }
    }
  }
  
  return 0;
}


int IC_Recv_short(IC_Program* from, IC_Sched* sched, short* data, int tag) {
  int proc;
  OneSched_s *Osched;
  
  setcall("IC_Recv_short");
  if (from == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }

  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme((pgme_s*)from,proc), tag);
      while (Osched != NULL) {
	pvm_upkshort(data+Osched->offset, Osched->size, 1); 
	Osched = Osched->next;	    
      }
    }
  }
  
  return 0;
}


int IC_Recv_int(IC_Program* from, IC_Sched* sched, int* data, int tag) {
  int proc;
  OneSched_s *Osched;
  
  setcall("IC_Recv_int");
  if (from == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }

  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme((pgme_s*)from,proc), tag);
      while (Osched != NULL) {
	pvm_upkint(data+Osched->offset, Osched->size, 1); 
	Osched = Osched->next;	    
      }
    }
  }
  
  return 0;
}


int IC_Recv_float(IC_Program* from, IC_Sched* sched, float* data, int tag) {
  int proc;
  OneSched_s *Osched;
  
  setcall("IC_Recv_float");
  if (from == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }

  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme((pgme_s*)from,proc), tag);
      while (Osched != NULL) {
	pvm_upkfloat(data+Osched->offset, Osched->size, 1); 
	Osched = Osched->next;	    
      }
    }
  }
  
  return 0;
}


int IC_Recv_double(IC_Program* from, IC_Sched* sched, double* data, int tag) {
  int proc;
  OneSched_s *Osched;
  
  setcall("IC_Recv_double");
  if (from == 0 || sched == NULL || data == 0) {
    errormsg("invalid parameters");
    return 0;
  }

  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme((pgme_s*)from,proc), tag);
      while (Osched != NULL) {
	pvm_upkdouble(data+Osched->offset, Osched->size, 1); 
	Osched = Osched->next;	    
      }
    }
  }
  
  return 0;
}



/*
 * Begin: Added by Tahsin Kurc
 *
 * The following functions are used to perform off-band communication 
 * between two programs.
 *
 */
int sBcastOutBand(pgme_s *to, short *data, int nelems, int tag)
{
  if (MyPosPgme(ic_this_program)==0) { /* do the broadcast to other program */
    pvm_initsend(PvmDataDefault);
    pvm_pkshort(data,nelems,1);
    pvm_bcast(to->name,tag);
  }
  
  /* syncronize all processors after send. */
  /*  pvm_barrier(ic_this_program->name,NumNodePgme(ic_this_program)); */
  return 1;
}

int iBcastOutBand(pgme_s *to, int *data, int nelems, int tag)
{
  if (MyPosPgme(ic_this_program)==0) { /* do the broadcast to other program */
    pvm_initsend(PvmDataDefault);
    pvm_pkint(data,nelems,1);
    pvm_bcast(to->name,tag);
  }
  
  /* syncronize all processors after send. */
  /*  pvm_barrier(ic_this_program->name,NumNodePgme(ic_this_program)); */
  return 1;
}

int fBcastOutBand(pgme_s *to, float *data, int nelems, int tag)
{
  if (MyPosPgme(ic_this_program)==0) { /* do the broadcast to other program */
    pvm_initsend(PvmDataDefault);
    pvm_pkfloat(data,nelems,1);
    pvm_bcast(to->name,tag);
  }
  
  /* syncronize all processors after send. */
  /* pvm_barrier(ic_this_program->name,NumNodePgme(ic_this_program)); */
  return 1;
}

int dBcastOutBand(pgme_s *to, double *data, int nelems, int tag)
{
  if (MyPosPgme(ic_this_program)==0) { /* do the broadcast to other program */
    pvm_initsend(PvmDataDefault);
    pvm_pkdouble(data,nelems,1);
    pvm_bcast(to->name,tag);
  }
  
  /* syncronize all processors after send. */
  /* pvm_barrier(ic_this_program->name,NumNodePgme(ic_this_program)); */
  return 1;
}

int cBcastOutBand(pgme_s *to, char *data, int nelems, int tag)
{
  if (MyPosPgme(ic_this_program)==0) { /* do the broadcast to other program */
    pvm_initsend(PvmDataDefault);
    pvm_pkstr(data);
    pvm_bcast(to->name,tag);
  }
  
  /* syncronize all processors after send. */
  /* pvm_barrier(ic_this_program->name,NumNodePgme(ic_this_program)); */
  return 1;
} 

int bBcastOutBand(pgme_s *to, char *data, int nelems, int tag)
{
  if (MyPosPgme(ic_this_program)==0) { /* do the broadcast to other program */
    pvm_initsend(PvmDataDefault);
    pvm_pkbyte(data,nelems,1);
    pvm_bcast(to->name,tag);
  }
  
  /* syncronize all processors after send. */
  /* pvm_barrier(ic_this_program->name,NumNodePgme(ic_this_program)); */
  return 1;
}

/*
 * Implementation of recv operations is closely related to implementation 
 * of broadcast operations above.
 */
int sRecvOutBand(pgme_s *from, short *data, int nelems, int tag)
{
  int bufid;
  int recvtid;
  
  recvtid = -1;
  if (from!=NULL)
    recvtid = pvm_gettid(from->name,0);
  bufid = pvm_recv(recvtid,tag);
  pvm_upkshort(data,nelems,1);
  return 1;
}  

int iRecvOutBand(pgme_s *from, int *data, int nelems, int tag)
{
  int bufid;
  int recvtid;
  
  recvtid = -1;
  if (from!=NULL)
    recvtid = pvm_gettid(from->name,0);
  bufid = pvm_recv(recvtid,tag);
  pvm_upkint(data,nelems,1);
  return 1;
}  

int fRecvOutBand(pgme_s *from, float *data, int nelems, int tag)
{
  int bufid;
  int recvtid;
  
  recvtid = -1;
  if (from!=NULL)
    recvtid = pvm_gettid(from->name,0);
  bufid = pvm_recv(recvtid,tag);
  pvm_upkfloat(data,nelems,1);
  return 1;
}  

int dRecvOutBand(pgme_s *from, double *data, int nelems, int tag)
{
  int bufid;
  int recvtid;
  
  recvtid = -1;
  if (from!=NULL)
    recvtid = pvm_gettid(from->name,0);
  bufid = pvm_recv(recvtid,tag);
  pvm_upkdouble(data,nelems,1);
  return 1;
}  

int cRecvOutBand(pgme_s *from, char *data, int nelems, int tag)
{
  int bufid;
  int recvtid;
  
  recvtid = -1;
  if (from!=NULL)
    recvtid = pvm_gettid(from->name,0);
  bufid = pvm_recv(recvtid,tag);
  pvm_upkstr(data);
  return 1;
}  

int bRecvOutBand(pgme_s *from, char *data, int nelems, int tag)
{
  int bufid;
  int recvtid;
  
  recvtid = -1;
  if (from!=NULL)
    recvtid = pvm_gettid(from->name,0);
  bufid = pvm_recv(recvtid,tag);
  pvm_upkbyte(data,nelems,1);
  return 1;
}  

/*
 * End: Added by Tahsin Kurc
 */

int sDataMoveSend(pgme_s *to, sched_s *sched, short *tab, int tag)
{
  int proc;
  OneSched_s *Osched; 
  int sendFlag;
  
  if (sched == NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) { 
    sendFlag = 0;
    Osched = sched->sched[proc];
    
    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkshort(tab+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     
    
    if (sendFlag == 1) {
      pvm_send(TidPgme(to,proc), tag);
    }
  }
  
  return 0;
}

int iDataMoveSend(pgme_s *to, sched_s *sched, int *tab, int tag)
{
  int proc;
  OneSched_s *Osched; 
  int sendFlag;
  
  if (sched == NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {
    sendFlag = 0;
    Osched = sched->sched[proc];

    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkint(tab+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     

    if (sendFlag == 1) {
      pvm_send(TidPgme(to,proc), tag);
    }
  }
  return 0;
}

int fDataMoveSend(pgme_s *to, sched_s *sched, float *tab, int tag)
{
  int proc;
  OneSched_s *Osched; 
  int sendFlag;

  if (sched == NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {
    sendFlag = 0;
    Osched = sched->sched[proc];

    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkfloat(tab+Osched->offset, Osched->size, 1);
      Osched = Osched->next;
    }     

    if (sendFlag == 1) {
      pvm_send(TidPgme(to,proc), tag);
    }
  }
  
  return 0;
}

int dDataMoveSend(pgme_s *to, sched_s *sched, double *tab, int tag)
{
  int proc;
  OneSched_s *Osched; 
  int sendFlag;
  
  if (sched==NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {
    sendFlag = 0;
    Osched = sched->sched[proc];

    if (Osched != NULL) {
      sendFlag = 1;
      pvm_initsend(GlueEncoding);
    }
    
    while (Osched != NULL) {
      pvm_pkdouble(tab+Osched->offset, Osched->size, 1); 	 
      Osched = Osched->next;
    }  
    
    if (sendFlag == 1) {
      pvm_send(TidPgme(to,proc), tag);
    }
  }

  return 0;
}

int sDataMoveRecv(pgme_s *from, sched_s *sched, short *tab, int tag)
{  
  int proc;
  OneSched_s *Osched;
  
  if (sched == NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme(from,proc), tag);
      while (Osched != NULL) {
	pvm_upkshort(tab+Osched->offset, Osched->size, 1);
	Osched = Osched->next;
      }
    }
  }
  
  return 0;
}

int iDataMoveRecv(pgme_s *from, sched_s *sched, int *tab, int tag)
{  
  int proc;
  OneSched_s *Osched;
  
  if (sched == NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme(from,proc), tag);
      while (Osched != NULL) {
	pvm_upkint(tab+Osched->offset, Osched->size, 1);
	Osched = Osched->next;
      }
    }
  }

  return 0;
}

int fDataMoveRecv(pgme_s *from, sched_s *sched, float *tab, int tag)
{  
  int proc;
  OneSched_s *Osched;

  if (sched == NULL) 
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme(from,proc), tag);
      while (Osched != NULL) {
	pvm_upkfloat(tab+Osched->offset, Osched->size, 1);
	Osched = Osched->next;
      }
    }
  }
  
  return 0;
}

int dDataMoveRecv(pgme_s *from, sched_s *sched, double *tab, int tag)
{  
  int proc;
  OneSched_s *Osched;
  
  if (sched == NULL)
    return 0;
  
  for (proc = 0; proc < sched->nproc; proc++) {       
    Osched = sched->sched[proc];
    if (Osched != NULL) {
      pvm_recv(TidPgme(from,proc), tag);
      while (Osched != NULL) {
	pvm_upkdouble(tab+Osched->offset, Osched->size, 1); 
	Osched = Osched->next;	    
      }
    }
  }
  
  return 0;
}

