#ifndef MOVE_H
#define MOVE_H

#include "pgme.h"
#include "schedule.h"
#include "boolean.h"

typedef int fifo_struct_t;
typedef int recv_data_t;
typedef int ep_data_t;
typedef int iHandler_t;

/* Out of Band communication routines.  */

/* Short Out Band Broadcast and Recv */ 
int sBcastOutBand(pgme_s *to, short *data, int nelems, int tag);
int sRecvOutBand(pgme_s *from, short *data, int nelems, int tag);

/* Integer Out Band Broadcast and Recv */ 
int iBcastOutBand(pgme_s *to, int *data, int nelems, int tag);
int iRecvOutBand(pgme_s *from, int *data, int nelems, int tag);

/* Float Out Band Broadcast and Recv */ 
int fBcastOutBand(pgme_s *to, float *data, int nelems, int tag);
int fRecvOutBand(pgme_s *from, float *data, int nelems, int tag);

/* Double Out Band Broadcast and Recv */
int dBcastOutBand(pgme_s *to, double *data, int nelems, int tag);
int dRecvOutBand(pgme_s *from, double *data, int nelems, int tag);

/* String Out Band Broadcast and Recv */ 
int cBcastOutBand(pgme_s *to, char *data, int nelems, int tag);
int cRecvOutBand(pgme_s *from, char *data, int nelems, int tag);

/* Byte Out Band Broadcast and Recv */
int bBcastOutBand(pgme_s *to, char *data, int nelems, int tag);
int bRecvOutBand(pgme_s *from, char *data, int nelems, int tag);


/* NON-BLOCKING send, receive functions  */

/* boolean test(iHandler_t ** handle); */
/* int wait(iHandler_t ** handle); */
  
int isDataMoveRecv(pgme_s *from, sched_s *sched, short *data, int tag, iHandler_t **handle);
int isDataMoveSend(pgme_s *to, sched_s *sched, short *data, int tag);
int iiDataMoveRecv(pgme_s *from, sched_s *sched, int *data, int tag, iHandler_t **handle);
int iiDataMoveSend(pgme_s *to, sched_s *sched, int *data, int tag);
int ifDataMoveRecv(pgme_s *from, sched_s *sched, float *data, int tag, iHandler_t **handle);
int ifDataMoveSend(pgme_s *to, sched_s *sched, float *data, int tag);
int idDataMoveRecv(pgme_s *from, sched_s *sched, double *data, int tag, iHandler_t **handle);
int idDataMoveSend(pgme_s *to, sched_s *sched, double *data, int tag);
		      
/* BLOCKING send, receive functions  */

/* Short data send/recv.*/
int sDataMoveRecv(pgme_s *from, sched_s *sched, short *data, int tag);
int sDataMoveSend(pgme_s *to, sched_s *sched, short *data, int tag);

/* Integer data send/recv. */
int iDataMoveSend(pgme_s *to, sched_s *sched, int *data, int tag);
int iDataMoveRecv(pgme_s *from, sched_s *sched, int *data, int tag);

/* Float data send/recv. */
int fDataMoveSend(pgme_s *to, sched_s *sched, float *data, int tag);
int fDataMoveRecv(pgme_s *from, sched_s *sched, float *data, int tag);

/* Double data send/recv. */
int dDataMoveSend(pgme_s *to, sched_s *sched, double *data, int tag);
int dDataMoveRecv(pgme_s *from, sched_s *sched, double *data, int tag);

#endif /* MOVE_H */
