// Henrique Andrade - March 2003
// University of Maryland, College Park
//
// Class Description:
// 
// This is an abstract class for an FILE_Endpoint. This class implements the
// EndPoint abstraction using files. This class can probably be used to 
// facilitate the development and debugging of coupling codes.

#ifndef EP_FILEENDPOINT_H
#define EP_FILEENDPOINT_H

#include <A++.h>
#include <fstream>
#include "EndPoint.h"

class FILE_EndPoint : public EndPoint {
  public:
    enum {
      SLEEP_TIME = 10*1000
    };
    FILE_EndPoint(const char* name);
    virtual int write(const char* buf, const unsigned nbytes);
    virtual int read(char*& buf, unsigned& nbytes);
    virtual void exportData(const doubleArray& a);
    virtual void importData(const doubleArray& a);
    virtual ~FILE_EndPoint();
  private:
    std::fstream f;
    char myName[IC_MAX_STR], otherName[IC_MAX_STR];
    static bool isLocalProgramInitzd;
};

#endif
