#ifndef IC_SUPPORT_H
#define IC_SUPPORT_H

#include <string>

#define MEM_TOTAL   0
#define MEM_USED    1
#define MEM_FREE    2
#define MEM_SHARED  3
#define MEM_BUFFERS 4
#define MEM_CACHED  5

int str2int(const char* ptr);
long long str2ll(const char* ptr);
int cmp_unsigned(const void* a, const void *b);
double convert2double(const char* str);
double convert2double(const int i);
double convert2double(const unsigned u);
double convert2double(const double d);
double convert2double(const void* i);
int getCpuInfo(const bool verbose=false);
double getWallClock(void);
double getCPUTime(void); 
char* StrDup(const char* sb);
char* StrRStr(const char* sbStr, const char* sbSub);
char* StrNDup(const char* sb, int n);
char* MemDup(const char *src, const unsigned srcsize);
char *StrNCpy(char* dest, const char* src, const unsigned maxsize);
char *StrNCat(char* dest, const char* src, const unsigned maxsize);
char* BaseName(const char* path, char* ans, const unsigned maxsize);
char* DirName(const char* path, char *ans, const unsigned maxsize);
void replaceAll(char* str, const char oldchar, const char newchar);
int USleep(const unsigned long int useconds);

void GetMyIPAddress(char* ipstr);

char* ll2suffix(long long n);

template<class typeT>
inline typeT fracPart(const typeT n);

template<class typeT>
inline typeT positiveFracPart(const typeT n);

template<class typeT>
inline bool isExact(const typeT n, const typeT precision);

template<class typeT>
inline bool isEqual(const typeT x, const typeT y, const typeT precision);

void* meminit(void* s1, const void* s2, unsigned n, size_t size);

unsigned i6862solarisu(unsigned i686u);
unsigned solaris2i686u(unsigned solarisu);

#endif
