#include <A++.h>
#include "InterComm.h"

extern "C" {
#include "general_bsparti.h"
IC_Desc* IC_Translate_parti_descriptor(DARRAY* darray);
}

// the functions below are used by the MetaChaos endpoint class as a means
// to access the Parti descriptors for the P++ arrays necessary for MetaChaos
// to establish the communications between the two parties.

IC_Desc* getPartiDescriptor(const intArray& array, const bool columnMajor) {
  IC_Desc* desc = IC_Translate_parti_descriptor(array.Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->pPARTI_Descriptor->getBlockPartiArrayDescriptor());    
  decomp_Birreg* decomp = (decomp_Birreg*)desc->spec;
  decomp->col_majeur = columnMajor;
#if IC_DEBUG
  print_irr(decomp->root);
#endif
  return desc;
}

IC_Desc* getPartiDescriptor(const floatArray& array, const bool columnMajor) {
  IC_Desc* desc = IC_Translate_parti_descriptor(array.Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->pPARTI_Descriptor->getBlockPartiArrayDescriptor());    
  decomp_Birreg* decomp = (decomp_Birreg*)desc->spec;
  decomp->col_majeur = columnMajor;
#if IC_DEBUG
  print_irr(decomp->root);
#endif
  return desc;
}

IC_Desc* getPartiDescriptor(const doubleArray& array, const bool columnMajor) {
  IC_Desc* desc = IC_Translate_parti_descriptor(array.Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->pPARTI_Descriptor->getBlockPartiArrayDescriptor());
  decomp_Birreg* decomp = (decomp_Birreg*)desc->spec;
  decomp->col_majeur = columnMajor;
#if IC_DEBUG
  print_irr(decomp->root);
#endif
  return desc;
}
