

#include "pplus2fortran.h"
#include "pplus2bparti.h"
extern "C" {
#include "fort_wrap.h"
}


int IC::Init(char* name, int tasks, int rank) {
  return pinsert((void*)IC_Init(name, tasks, rank));
}
 
int IC::Wait(char* name, int tasks) {
  return pinsert((void*)IC_Wait(name, tasks));
}
 
int IC::Sync(int myprog, int prog) {
  return IC_Sync((IC_Program*)plookup(myprog), (IC_Program*)plookup(prog));
}







int IC::Create_bdecomp_desc(intArray& a) {
  IC_Desc* desc = getPartiDescriptor(a);
  return pinsert((void*)desc);
}


int IC::Create_bdecomp_desc(floatArray& a) {
  IC_Desc* desc = getPartiDescriptor(a);
  return pinsert((void*)desc);
}


int IC::Create_bdecomp_desc(doubleArray& a) {
  IC_Desc* desc = getPartiDescriptor(a);
  return pinsert((void*)desc);
}



int IC::Create_block_region(intArray& a) {
  unsigned int ndims = a.numberOfDimensions();
  int lower[IC_MAX_DIM], upper[IC_MAX_DIM], stride[IC_MAX_DIM];
  for (int i = 0; i < ndims; ++i) {
    lower[i] = a.getBase(i);
    upper[i] = a.getBound(i);
    stride[i] = a.getStride(i);
  }
  return pinsert((void*)IC_Create_block_region(ndims, lower, upper, stride));
}


int IC::Create_block_region(floatArray& a) {
  unsigned int ndims = a.numberOfDimensions();
  int lower[IC_MAX_DIM], upper[IC_MAX_DIM], stride[IC_MAX_DIM];
  for (int i = 0; i < ndims; ++i) {
    lower[i] = a.getBase(i);
    upper[i] = a.getBound(i);
    stride[i] = a.getStride(i);
  }
  return pinsert((void*)IC_Create_block_region(ndims, lower, upper, stride));
}


int IC::Create_block_region(doubleArray& a) {
  unsigned int ndims = a.numberOfDimensions();
  int lower[IC_MAX_DIM], upper[IC_MAX_DIM], stride[IC_MAX_DIM];
  for (int i = 0; i < ndims; ++i) {
    lower[i] = a.getBase(i);
    upper[i] = a.getBound(i);
    stride[i] = a.getStride(i);
  }
  return pinsert((void*)IC_Create_block_region(ndims, lower, upper, stride));
}


int IC::Compute_schedule(int myprog, int prog, int desc, int* region_set, int set_size) {
  IC_Region** regions = new IC_Region*[set_size];
  for (int i = 0; i < set_size; ++i) {
    regions[i] = (IC_Region*)plookup(region_set[i]);
  }
  return pinsert((void*)IC_Compute_schedule((IC_Program*)plookup(myprog), (IC_Program*)plookup(prog), (IC_Desc*)plookup(desc), regions, set_size));
}
