#ifndef REGION_H
#define REGION_H

#include "intercomm.h"

#define number_of_region_type 2
#define sizeRegion(region) (region->size)

typedef IC_Region region_s;

typedef struct {
  int NumRegion;
  region_s** regions;
  int* BeginGlobalOffset;
} setOfRegion_s;

void Free_Region(region_s*);
void Print_Region(region_s*);
void getRegionName(region_s*, char*);

setOfRegion_s* Alloc_setOfRegion();
setOfRegion_s* Add_Region_setOfRegion(region_s*, setOfRegion_s*);
setOfRegion_s* Add_LocalRegion_setOfRegion(region_s*, setOfRegion_s*, int);
void Free_setOfRegion(setOfRegion_s*);
void Print_setOfRegion(setOfRegion_s*);
int SizeSetOfRegion(setOfRegion_s*);
int NbRegionSetOfRegion(setOfRegion_s*);

typedef struct {
  T_RegionType type;
  T_RegionDistribution distribution;
  T_MemOp mem_type;
  int size;
  int* globalCoord;
} region_enum_s;

region_s* Alloc_R_Enum(int, int*, T_RegionDistribution, T_MemOp);
void Free_R_Enum(region_enum_s*);
void Print_R_Enum(region_enum_s*);

typedef struct {
  T_RegionType type;
  T_RegionDistribution distribution;
  T_MemOp mem_type;
  int size;
  int nbDim;
  int* left;
  int* right;
  int* stride;  
} region_hpf_s;

region_s* Alloc_R_HPF(int, int*, int*, int*, T_RegionDistribution, T_MemOp);
void Free_R_HPF(region_hpf_s*);
void Print_R_HPF(region_hpf_s*);

#endif /* REGION_H */
