#include "ctest_table.h"
#include "ctest.h"
#include <stdlib.h>

extern char* groupname;
extern IC_Program* this;

extern int TT[DESCS2][TASKS][2][SIZE];
extern int TS[XFERS2][8];
extern int TR[XFERS2][8];

extern int XS2[XFERS2];
extern int XS3[XFERS3];

IC_Desc* create_desc(int d, int rank, int* size, int** A) {
  IC_Desc* desc = 0;
  int globals[SIZE];
  int i, j;

  for (i = 0; i < SIZE; ++i) {
    globals[i] = i + SIZE*rank;
  }
  
  if ((desc = IC_Create_ttable_desc(globals, TT[d][rank][OFF], TT[d][rank][TSK], SIZE)) == 0) {
    fprintf(stderr, "error creating descriptor\n");
    return 0;
  }
  
  /* debugging */
/*   { */
/*     simple_ttable* table = desc->spec; */
/*     Print_simple_ttable(table); */
/*   } */

  *size = SIZE;
  *A = (int*)calloc(SIZE, sizeof(int));

  return desc;
}

void init_array(int* size, int* A, int d, int rank) {
  int i, j;
  
  for (i = 0; i < TASKS; ++i) {
    for (j = 0; j < SIZE; ++j) {
      if (rank == TT[d][i][TSK][j])
	*(A+TT[d][i][OFF][j]) = j + i*SIZE;
    }
  }
}

int send_region(IC_Program* receiver, IC_Desc* desc, int r, int* A, int cnt, int dims) {
  IC_Region* regions[XFERS2];
  IC_Sched* sched;
  int i;

  for (i = 0; i < cnt; ++i) {
    switch (dims) {
    case 2:
      regions[i] = IC_Create_enum_region(TS[r+i], XS2[r+i]);
      break;
    case 3:
      regions[i] = IC_Create_enum_region(TS[r+i], XS3[r+i]);
      break;
    }
    if (!regions[i]) {
      fprintf(stderr, "error creating send region\n");
      return 0;
    }

/*     Print_Region(regions[i]); */
  }
  
  if ((sched = IC_Compute_schedule(this, receiver, desc, regions, cnt)) == 0) {
    fprintf(stderr, "error creating schedule\n");
    return 0;
  }
  
  if (IC_Send_int(receiver, sched, A, 666) < 0) {
    fprintf(stderr, "error on send\n");
    return 0;
  }
  
  if (IC_Sync(this, receiver) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 0;
  }  
  
  IC_Free_sched(sched);
  for (i = 0; i < cnt; ++i) {
    IC_Free_region(regions[i]);
  }

  return 1;
}

int recv_region(IC_Program* sender, IC_Desc* desc, int r, int* A, int cnt, int dims) {
  IC_Region* regions[XFERS2];
  IC_Sched* sched;
  int i;
  
  for (i = 0; i < cnt; ++i) {
    switch (dims) {
    case 2:
      regions[i] = IC_Create_enum_region(TR[r+i], XS2[r+i]);
      break;
    case 3:
      regions[i] = IC_Create_enum_region(TR[r+i], XS3[r+i]);
      break;
    }
    if (!regions[i]) {
      fprintf(stderr, "error creating recv region\n");
      return 0;      
    }

/*     Print_Region(regions[i]); */
  }
  
  if ((sched = IC_Compute_schedule(this, sender, desc, regions, cnt)) == 0) {
    fprintf(stderr, "error creating schedule\n");
    return 0;
  }
  
  if (IC_Recv_int(sender, sched, A, 666) < 0) {
    fprintf(stderr, "error on send\n");
    return 0;
  }
  
  if (IC_Sync(this, sender) < 0) {
    fprintf(stderr, "error synchronizing programs\n");
    return 0;
  }  
  
  IC_Free_sched(sched);
  for (i = 0; i < cnt; ++i) {
    IC_Free_region(regions[i]);
  }
  
  return 1;
}

int sendrecv(int rank, int test, IC_Program* prog, int bcnt, int ndim, int descs, int xfers) {
  IC_Desc* desc = 0;
  int table, region;
  int* A, size[MAXDIM];
  int sts;
  
  table = 0;
  while (table < descs) {
    desc = create_desc(table, rank, size, &A);
    if (!desc)
      return 0;
    
    region = 0;
    while (region < xfers - bcnt) {
      
      /* send */
      init_array(size, A, table, rank);
      if (!send_region(prog, desc, region, A, bcnt, ndim))
	return 0;

      ++region;
      
      /* recv */
      init_array(size, A, table, rank);
      if (!recv_region(prog, desc, region, A, bcnt, ndim))
	return 0;
      sts = verify_recv(prog, desc, A, size, rank, table, region, bcnt, ndim);
      sts = pvm_allstatus(groupname, sts, table*10+region);
      if (rank == 0) {
	if (!sts) 
	  printf("test %d.%d.%d failed\n", test, table+1, region+1);
	else 
	  printf("test %d.%d.%d succeeded\n", test, table+1, region+1);	
      }
      if (!sts)
	fprint_array(stdout, 'i', A, 1, size, 0, 0);

      ++region;
    }
    
    free(A);
    IC_Free_desc(desc);

    table += 2;
  }

  return 1;
}

int recvsend(int rank, int test, IC_Program* prog, int bcnt, int ndim, int descs, int xfers) {
  IC_Desc* desc = 0;
  int table, region;
  int* A, size[MAXDIM];
  int sts;

  table = 1;
  while (table < descs) {
    desc = create_desc(table, rank, size, &A);
    if (!desc)
      return 0;
    
    region = 0;
    while (region < xfers - bcnt) {    

      /* recv */
      init_array(size, A, table, rank);
      if (!recv_region(prog, desc, region, A, bcnt, ndim))
	return 0;          
      sts = verify_recv(prog, desc, A, size, rank, table, region, bcnt, ndim);
      sts = pvm_allstatus(groupname, sts, table*10+region);
      if (rank == 0) {
	if (!sts)
	  printf("test %d.%d.%d failed\n", test, table+1, region+1);
	else
	  printf("test %d.%d.%d succeeded\n", test, table+1, region+1);
      }
      if (!sts)
	fprint_array(stdout, 'i', A, 1, size, 0, 0);

      ++region;

      /* send */
      init_array(size, A, table, rank);
      if (!send_region(prog, desc, region, A, bcnt, ndim))
	return 0;

      ++region;
    }
    
    free(A);
    IC_Free_desc(desc);

    table += 2;
  }
  
  return 1;
}
