#include "ctest.h"
#include "ctest_block.h"
#include "pvm_utils.h"
#include <intercomm.h>
#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>

char* groupname = "west";
char* othername = "east";
char* thirdname = "north";

IC_Program* this;
IC_Program* other;
IC_Program* third;

int main(int argc, char* argv[]) {
  int rank, test;
  int bcnt, ndim;
  int* A, size[MAXDIM];
  IC_Desc* desc;

  if (!common_startup(argc, argv, &rank, &test))
    return 1;

  if (rank == 0)
    printf("starting tests\n");
  
  bcnt = 1; 
  ndim = 2;

  /* BDECOMP <-> BDECOMP */
  if (test == 0 || test == 1) {
    if (rank == 0)
      printf("testing 2D bdecomp <-> 2D bdecomp transfers...\n");
    sendrecv(rank, 1, other, bcnt, ndim, DESCS2, XFERS2);
  }
  
  /* BDECOMP <-> TTABLE */
  if (test == 0 || test == 2) {
    if (rank == 0)
      printf("testing 2D bdecomp <-> ttable transfers...\n");
    sendrecv(rank, 2, third, bcnt, ndim, DESCS2, XFERS2);
  }

  bcnt = 2;

  /* MULTIPLE REGIONS */
  if (test == 0 || test == 3) {
    if (rank == 0)
      printf("testing multi-region 2D bdecomp <-> 2D bdecomp transfers...\n");
    sendrecv(rank, 3, other, bcnt, ndim, DESCS2, XFERS2);
  }

  if (test == 0 || test == 4) {   
    if (rank == 0)
      printf("testing multi-region 2D bdecomp <-> ttable transfers...\n");
    sendrecv(rank, 4, third, bcnt, ndim, DESCS2, XFERS2);
  }
  
  bcnt = 1;
  ndim = 3;

  /* 3 DIMENSIONS */
  if (test == 0 || test == 5) {
    if (rank == 0) 
      printf("testing 3D bdecomp <-> 3D bdecomp transfers...\n");
    sendrecv(rank, 5, other, bcnt, ndim, DESCS3, XFERS3);
  }

  if (test == 0 || test == 6) {
    if (rank == 0) 
      printf("testing 3D bdecomp <-> ttable transfers...\n");
    sendrecv(rank, 6, third, bcnt, ndim, DESCS3, XFERS3);
  }

  bcnt = 2;

/*   if (test == 0 || test == 7) { */
/*     if (rank == 0)  */
/*       printf("testing multi-region 3D bdecomp <-> 3D bdecomp transfers...\n"); */
/*     sendrecv(rank, 7, other, bcnt, ndim, DESCS3, XFERS3); */
/*   } */

/*   if (test == 0 || test == 8) { */
/*     if (rank == 0)  */
/*       printf("testing multi-region 3D bdecomp <-> ttable transfers...\n"); */
/*     sendrecv(rank, 8, third, bcnt, ndim, DESCS3, XFERS3); */
/*   } */

  /* cleanup */
  IC_Free_program(third);
  IC_Free_program(other);
  IC_Quit(this);
  
  pvm_barrier(groupname, TASKS);
  pvm_exit();  

  if (rank == 0)
    printf("tests complete\n");

  return 0;
}
