#include "chaos_ctest.h"
#include <ttable.h>
#include <chaos2ttable.h>
#include <stdlib.h>
#include <stdio.h>

int sr1[] = {0,1,2,3,4,5,6,7}; int ss1 = 8;
int rr1[] = {0,1,2,3,4,5,6,7}; int rs1 = 8;

int sr2[] = {16,17,18,19,20,21,22,23}; int ss2 = 8;
int rr2[] = {16,17,18,19,20,21,22,23}; int rs2 = 8;

int sr3[] = {32,33,34,35,36,37,38,39}; int ss3 = 8;
int rr3[] = {32,33,34,35,36,37,38,39}; int rs3 = 8;

int sr4[] = {48,49,50,51,52,53,54,55}; int ss4 = 8;
int rr4[] = {48,49,50,51,52,53,54,55}; int rs4 = 8;

int* create_ttable(IC_Desc** desc, int p, int r, int* local_size) {
  int i, l;
  int gi[SIZE];
  int li[SIZE];
  int* A;
  TTABLE* tt;

  /* assign indices in cyclic fashion */
  *local_size = SIZE/p;
  for (i = 0; i < *local_size; ++i) {
    gi[i] = i*p + r;
  }

  /* assign the remaining indices to the first task */
  if (r == 0) {
    *local_size += SIZE%p;
    l = (SIZE/p)*p;
    while (i < *local_size) {
      gi[i] = l;
      ++i; ++l;
    }
  }
  
  tt = build_translation_table(1, gi, *local_size);
  derefoffset(tt, gi, li, *local_size, OFF);

  A = (int*)calloc(*local_size, sizeof(int));
  for (i = 0; i < *local_size; ++i) {
    A[li[i]] = gi[i];
  }
  
  *desc = IC_Translate_chaos_descriptor(tt);

  free_table(tt);

  return A;  
}

void print_array(FILE* fp, int* A, int size) {
  int i;
  
  for (i = 0; i < size; ++i) {
    fprintf(fp, "A[%d]=%d\n", i, A[i]);
  }
}
