#!/bin/sh

pvmdir=$HOME/pvm3/bin/$PVM_ARCH
mkdir -p $pvmdir
cp f90test_west f90test_east f90test_nort f90test_sout $pvmdir
echo "quit" | pvm > /dev/null
if test $? -eq 1; then
  exit 1
fi

$pvmdir/f90test_west &
west=$!
$pvmdir/f90test_east &
east=$!
$pvmdir/f90test_nort &
north=$!
$pvmdir/f90test_sout &
south=$!

wait $west
if test $? -ne 0; then
  exit 1
fi
wait $east
if test $? -ne 0; then
  exit 1
fi
wait $north
if test $? -ne 0; then
  exit 1
fi
wait $south
if test $? -ne 0; then
  exit 1
fi

ps -u $USER -o pid,comm | grep pvmd3 > /tmp/pkill
pid=`awk '{ print $1 }' /tmp/pkill`
kill -TERM $pid
exit 0
