#!/bin/ksh
# @ job_type = parallel
# @ output = $(initialdir)/l2r.out
# @ error = $(initialdir)/l2r.error
# @ network.MPI = csss,shared,US
# @ node_usage = shared
# @ node = 2
# @ tasks_per_node = 1
# @ wall_clock_limit = 240
# @ class = share
# @ queue

rm -f ~/*.WE > /dev/null
echo "Starting up PVM..."
echo "This is the PVM configuration..."
l2r.pl 8 8
if [ "$?" -ne "0" ]; then
  echo "Problem starting up PVM..."
  exit 1
fi

echo "Running the POE job"

export MP_PGMMODEL=mpmd
export MP_CMDFILE=l2r.programs
export MP_STDOUTMODE=ordered
export MP_LABELIO=yes

poe
echo "Shutting down PVM..."
echo "conf\nhalt\n" | pvm
### Finishing up and ensuring a non-error return code
echo "Multi-application run has ended"
