! program to test low-level Intercomm interface
! Henrique - 3/23/2004
program rf90lowlevel
  use pvmf90
  use intercomm_interface
  use array_printing
  implicit none

  character*16 localname
  data localname / 'rightside' /
  character*16 othername
  data othername / 'leftside' /
  integer local_tasks
  data local_tasks / 8 /
  integer other_tasks
  data other_tasks / 8 /
  integer i, rank

  character*16 groupcomm
  data groupcomm / 'right_group' /

  integer local
  integer other

  integer desc
  real A(5,5,5)
  type(arraydesc) :: ADesc
  integer started

  integer region_set(2)
  integer lower(3), upper(3), stride(3)
  integer sched
  integer tag
  data tag / 99 /
  integer sts

  integer nhost
  integer narch
  integer htid
  integer tid
  character*80 dname
  character*80 arch
  integer speed

!     initialize tasks
  call pvmfstartup(local_tasks, started)
  call pvmfjoingroup(groupcomm, rank)
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: initializing pvm'
  end if
  if (rank .LT. 0) then
    call pvmfperror('joingroup', rank)
    stop
  else
    call pvmfbarrier(groupcomm, local_tasks, sts)
    if (sts .LT. 0) then
      call pvmfperror('barrier', sts)
      stop
    end if
  end if

  call pvmfconfig(nhost,narch,htid,dname,arch,speed,sts)
  call pvmfmytid(tid)
  call pvmftidtohost(tid,htid)
  print *, 'rf90lowlevel: task tid', tid,'running on hostid',htid
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: initializing InterComm -- running', started,'tasks on',nhost,'hosts'
  end if

!     initialize ic
  call IC_Init(localname, local_tasks, rank, local)    
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: waiting for remote party'
  end if
  call IC_Wait(othername, other_tasks, other)
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: remote party has started'
  end if

!     create a block decomposition type array descriptor and array
  call create_bdecomp(local_tasks, rank, A, desc)

!     define two 2x2x2 regions for transfer
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: defining regions'
  end if
  do i = 1, 3
     lower(i) = 1
     upper(i) = 2
     stride(i) = 1
  end do
  call IC_Create_block_region(3, lower, upper, stride, region_set(1))
  do i = 1, 3
     lower(i) = 3
     upper(i) = 4
     stride(i) = 1
  end do
  call IC_Create_block_region(3, lower, upper, stride, region_set(2))

  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: creating schedule'
  end if
  call IC_Compute_schedule(local, other, desc, region_set, 2, sched)
  A=20;
  ADesc = createArrayDesc(A)
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: array before data is received'
    call printRealArray(ADesc)
  end if
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: receiving data'
  end if
  call IC_Recv(other, sched, A, tag, sts)
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: array after data is received'
    call printRealArray(ADesc)
  end if
  call IC_Sync(local, other, sts)
  call IC_Free_sched(sched)

!     cleanup
  if (rank .EQ. 0) then
    print *, 'rf90lowlevel: cleaning up'
  end if
  call IC_Free_region(region_set(2))
  call IC_Free_region(region_set(1))

  call IC_Free_desc(desc)

  call IC_Free_program(other)      
  call IC_Quit(local, sts)

end


subroutine create_bdecomp(p, r, A, desc)
  use intercomm_interface
  implicit none
  integer p, r
  real A(5,5,5)
  integer desc

  integer blocks(8,2,3)
  integer tasks(8)      
  integer i, j, k

!     bisect the global array in each dimension
  do i = 0, 1
     do j = 0, 1
        do k = 0, 1
           blocks(4*i+2*j+k+1,1,1) = i*5 + 1
           blocks(4*i+2*j+k+1,2,1) = i*5 + 5
           blocks(4*i+2*j+k+1,1,2) = j*5 + 1
           blocks(4*i+2*j+k+1,2,2) = j*5 + 5
           blocks(4*i+2*j+k+1,1,3) = k*5 + 1
           blocks(4*i+2*j+k+1,2,3) = k*5 + 5
        end do
     end do
  end do

!     assign the blocks to the tasks
  do i = 1, 8
     tasks(i) = i - 1
  end do

!     create the ic descriptor
  call IC_Create_bdecomp_desc(3, blocks, tasks, 8, desc)

end
